package com.taobao.eagleeye;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 提供给 LocalContext 和 RpcContext 共用的公共类
 * @since 1.5.0-exported
 */
abstract class AbstractContext extends BaseContext {

	AbstractContext(String _traceId, String _rpcId) {
		this(_traceId, _rpcId, new AtomicInteger(0));
	}

	AbstractContext(String _traceId, String _rpcId, AtomicInteger _localIdx) {
		super(_traceId, _rpcId);
	}

	public String getLocalId() {
		return null;
	}
	public long getRequestSize() {
		return 0L;
	}
	public void setRequestSize(long requestSize) {
	}
	public long getResponseSize() {
		return 0L;
	}
	public void setResponseSize(long responseSize) {
	}
	public String getRemoteIp() {
		return null;
	}
	public void setRemoteIp(String remoteIp) {
	}
	public void setStartTime(long startTime) {
	}
	public long getStartTime() {
		return 0L;
	}
	public void setTimeSpan0(int span0) {
	}
	public int getTimeSpan0() {
		return 0;
	}
	public void setTimeSpan1(int span1) {
	}
	public int getTimeSpan1() {
		return 0;
	}

	/**
	 * 设置业务的状态码（不要有可变参数在里面，因为要进行统计）
	 * @param bizResultCode
	 */
	public void setBizResultCode(String bizResultCode) {
	}

	/**
	 * 检查当前上下文是否被采样，有效范围在 [1, 9999] 之间，超出范围的数值都作为全采样处理。
	 * @return <code>true</code> 则需要输出日志，<code>false</code> 不输出
	 */
	public final boolean isTraceSampled() {
		return true;
	}

	/**
	 * 检查当前上下文是否被采样，有效范围在 [1, 9999] 之间，超出范围的数值都作为全采样处理。
	 *
	 * @return <code>true</code> 则需要输出日志，<code>false</code> 不输出
	 * @param samplingInterval
	 */
	public final boolean isTraceSampled(int samplingInterval) {
		return true;
	}

	public String putUserData(String key, String value) {
		return null;
	}
	public String removeUserData(String key) {
		return null;
	}
	public String getUserData(String key) {
		return null;
	}
    public Map<String, String> getUserDataMap() {
		return null;
    }
	public String putLocalAttribute(String key, String value) {
		return null;
	}
	public String removeLocalAttribute(String key) {
		return null;
	}
	public String getLocalAttribute(String key) {
		return null;
	}
    public Map<String, String> getLocalAttributeMap() {
		return null;
    }
	public Object putAttachment(String key, Object value) {
		return null;
	}
	public Object removeAttachment(String key) {
		return null;
	}
	public Object getAttachment(String key) {
		return null;
	}
    public Map<String, Object> getAttachmentMap() {
		return null;
    }

    /**
	 * 导出需要透传的 UserData
	 */
	public String exportUserData() {
		return null;
	}

	/**
	 * 导出需要透传的 UserData, 导出的形式为可打印的字符
	 * 类似于 URL ? 之后的参数: k1=v1&k2=v2&
	 * 适用于对明文协议(比如 HTTP)做埋点时导出 userData
	 */
	public String exportPrintableUserData() {
		return null;
	}

	/**
	 * 导入透传过来的 UserData
	 * @param userData
	 */
	public void importUserData(String userData) {
	}

	/**
	 * 导入透传过来的 UserData (类似于 URL ?之后的参数: k1=v1&k2=v2&)
	 * 注意: 此接口暂时没有对 & = 进行 escape
	 * 适用于导入明文协议(比如 HTTP)传递过来的 userData
	 *
	 * @param userData
	 */
	public void importPrintableUserData(String userData) {
	}
}
