package com.taobao.csp.sentinel.slots.block;

import com.taobao.csp.sentinel.util.SentinelUtil;

/***
 * 授权限流降级抽象异常
 * 
 * @author youji.zj youji.zj@taobao.com
 * @since 2014-5-17
 *
 */
public abstract class BlockException extends Exception {

	private static final long serialVersionUID = -3127548990739711600L;
	
	public static RuntimeException THROW_OUT_EXCEPTION = new RuntimeException(SentinelUtil.BLOCL_EXCELTION_FLAG);
	
	public static final String BLOCK = "BLOCK";
	
	public static StackTraceElement[] sentinelStackTrace = new StackTraceElement[] {
			 new StackTraceElement(BlockException.class.getName(),"block","BlockException",0)
			};
	
	static {
		THROW_OUT_EXCEPTION.setStackTrace(sentinelStackTrace);
	}
	
	private String ruleLimitApp; 

	public BlockException(String ruleLimitApp) {
		super();
		this.ruleLimitApp = ruleLimitApp;
	}

	public BlockException(String message, Throwable cause) {
		super(message, cause);
	}

	public BlockException(String ruleLimitApp, String message) {
		super(message);
		this.ruleLimitApp = ruleLimitApp;
	}
	
	 @Override
	 public Throwable fillInStackTrace() {
		 return this;
	 }

	public String getRuleLimitApp() {
		return ruleLimitApp;
	}

	public void setRuleLimitApp(String ruleLimitApp) {
		this.ruleLimitApp = ruleLimitApp;
	}
}
