/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.utils;

import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.utils.IPUtil;
import com.taobao.diamond.utils.StringUtils;
import java.util.List;

public class ParamUtils {
    private static char[] validChars = new char[]{'_', '-', '.', ':'};

    public static boolean isValid(String param) {
        if (param == null) {
            return false;
        }
        int length = param.length();
        for (int i = 0; i < length; ++i) {
            char ch = param.charAt(i);
            if (Character.isLetterOrDigit(ch) || ParamUtils.isValidChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char ch) {
        for (char c : validChars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static void checkKeyParam(String dataId, String group) throws DiamondException {
        if (StringUtils.isBlank(dataId) || !ParamUtils.isValid(dataId)) {
            throw new DiamondException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank(group) || !ParamUtils.isValid(group)) {
            throw new DiamondException(-400, "group invalid");
        }
    }

    public static void checkTDG(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        if (StringUtils.isBlank(dataId) || !ParamUtils.isValid(dataId)) {
            throw new DiamondException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank(group) || !ParamUtils.isValid(group)) {
            throw new DiamondException(-400, "group invalid");
        }
    }

    public static void checkKeyParam(String dataId, String group, String datumId) throws DiamondException {
        if (StringUtils.isBlank(dataId) || !ParamUtils.isValid(dataId)) {
            throw new DiamondException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank(group) || !ParamUtils.isValid(group)) {
            throw new DiamondException(-400, "group invalid");
        }
        if (StringUtils.isBlank(datumId) || !ParamUtils.isValid(datumId)) {
            throw new DiamondException(-400, "datumId invalid");
        }
    }

    public static void checkKeyParam(List<String> dataIds, String group) throws DiamondException {
        if (dataIds == null || dataIds.size() == 0) {
            throw new DiamondException(-400, "dataIds invalid");
        }
        for (String dataId : dataIds) {
            if (!StringUtils.isBlank(dataId) && ParamUtils.isValid(dataId)) continue;
            throw new DiamondException(-400, "dataId invalid");
        }
        if (StringUtils.isBlank(group) || !ParamUtils.isValid(group)) {
            throw new DiamondException(-400, "group invalid");
        }
    }

    public static void checkParam(String dataId, String group, String content) throws DiamondException {
        ParamUtils.checkKeyParam(dataId, group);
        if (StringUtils.isBlank(content)) {
            throw new DiamondException(-400, "content invalid");
        }
    }

    public static void checkParam(String dataId, String group, String datumId, String content) throws DiamondException {
        ParamUtils.checkKeyParam(dataId, group, datumId);
        if (StringUtils.isBlank(content)) {
            throw new DiamondException(-400, "content invalid");
        }
    }

    public static void checkTenant(String tenant) throws DiamondException {
        if (StringUtils.isBlank(tenant) || !ParamUtils.isValid(tenant)) {
            throw new DiamondException(-400, "tenant invalid");
        }
    }

    public static void checkBetaIps(String betaIps) throws DiamondException {
        String[] ipsArr;
        if (StringUtils.isBlank(betaIps)) {
            throw new DiamondException(-400, "betaIps invalid");
        }
        for (String ip : ipsArr = betaIps.split(",")) {
            if (IPUtil.isIPV4(ip)) continue;
            throw new DiamondException(-400, "betaIps invalid");
        }
    }

    public static void checkContent(String content) throws DiamondException {
        if (StringUtils.isBlank(content)) {
            throw new DiamondException(-400, "content invalid");
        }
    }
}

