/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.manager.impl;

import com.taobao.diamond.manager.ManagerListenerAdapter;
import java.text.SimpleDateFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DelayLoadListener
extends ManagerListenerAdapter {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Pattern pattern = Pattern.compile("diamond-config-effective-time\\s*=\\s*\"(.*?)\"");
    private ScheduledExecutorService scheduled = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("com.taobao.diamond.manager.impl.DelayLoadListener");
            t.setDaemon(true);
            return t;
        }
    });
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private volatile ScheduledFuture<?> previousTask;

    @Override
    public synchronized void receiveConfigInfo(String configInfo) {
        if (configInfo == null || configInfo.length() == 0) {
            return;
        }
        long delay = this.getDelay(configInfo);
        this.delayReceive(configInfo, delay);
    }

    private void delayReceive(final String configInfo, long delay) {
        if (this.previousTask != null) {
            this.previousTask.cancel(false);
        }
        if (delay > 0L) {
            this.previousTask = this.scheduled.schedule(new Runnable(){

                @Override
                public void run() {
                    DelayLoadListener.this.innerReceive(configInfo);
                }
            }, delay, TimeUnit.MILLISECONDS);
        } else {
            this.innerReceive(configInfo);
        }
    }

    public abstract void innerReceive(String var1);

    private long getDelay(String configInfo) {
        long delay = 0L;
        try {
            delay = this.getEffectiveTime(configInfo) - System.currentTimeMillis();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (delay < 0L) {
            delay = 0L;
        }
        return delay;
    }

    private long getEffectiveTime(String configInfo) {
        long time = 0L;
        Matcher matcher = pattern.matcher(configInfo);
        String data = null;
        if (matcher.find()) {
            data = matcher.group(1);
        }
        if (data != null) {
            try {
                time = this.format.parse(data.trim()).getTime();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return time;
    }
}

