/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.middleware.tls;

import com.alibaba.middleware.tls.log.TlsLogger;
import com.alibaba.middleware.tls.util.FileUtil;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SelfTrustManager {
    static TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    public static TrustManager[] trustManager(boolean clientAuth, String trustCertPath) {
        if (clientAuth) {
            try {
                return trustCertPath == null ? null : SelfTrustManager.buildSecureTrustManager(trustCertPath);
            }
            catch (SSLException e) {
                TlsLogger.warn("degrade trust manager as build failed, will trust all certs.");
                return trustAll;
            }
        }
        return trustAll;
    }

    private static TrustManager[] buildSecureTrustManager(String trustCertPath) throws SSLException {
        TrustManager[] trustManagerArray;
        TrustManagerFactory selfTmf = null;
        FileInputStream in = null;
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            selfTmf = TrustManagerFactory.getInstance(algorithm);
            KeyStore trustKeyStore = KeyStore.getInstance("JKS");
            trustKeyStore.load(null, null);
            in = new FileInputStream(trustCertPath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(in);
            int count = 0;
            for (Certificate certificate : certs) {
                trustKeyStore.setCertificateEntry("cert-" + count++, certificate);
            }
            selfTmf.init(trustKeyStore);
            trustManagerArray = selfTmf.getTrustManagers();
        }
        catch (Exception e) {
            try {
                TlsLogger.error("build client trustManagerFactory failed", e);
                throw new SSLException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly(in);
                throw throwable;
            }
        }
        FileUtil.closeQuietly(in);
        return trustManagerArray;
    }
}

