/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.edas.acm.filter;

import com.alibaba.acm.shaded.com.aliyuncs.DefaultAcsClient;
import com.alibaba.acm.shaded.com.aliyuncs.exceptions.ClientException;
import com.alibaba.acm.shaded.com.aliyuncs.http.FormatType;
import com.alibaba.acm.shaded.com.aliyuncs.http.MethodType;
import com.alibaba.acm.shaded.com.aliyuncs.http.ProtocolType;
import com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.alibaba.acm.shaded.com.aliyuncs.profile.DefaultProfile;
import com.alibaba.edas.acm.filter.IACMConfigFilter;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.manager.IConfigFilterChain;
import com.taobao.diamond.manager.IConfigRequest;
import com.taobao.diamond.manager.IConfigResponse;
import com.taobao.diamond.manager.IFilterConfig;
import com.taobao.diamond.manager.impl.ConfigRequest;
import com.taobao.diamond.manager.impl.ConfigResponse;

public class KMSConfigFilter
implements IACMConfigFilter {
    private DefaultAcsClient kmsClient;
    private String keyId;
    private int order = 100;
    private static final String SAFE_CONFIG_PREFIX = "cipher-";

    @Override
    public void doFilter(IConfigRequest request, IConfigResponse response, IConfigFilterChain filterChain) throws DiamondException {
        try {
            ConfigRequest requestTmp = (ConfigRequest)request;
            ConfigResponse responseTmp = (ConfigResponse)response;
            if (request != null && requestTmp.getDataId().startsWith(SAFE_CONFIG_PREFIX) && requestTmp.getContent() != null) {
                requestTmp.setContent(this.encrypt(this.keyId, requestTmp.getContent()));
            }
            filterChain.doFilter(requestTmp, responseTmp);
            if (responseTmp != null && responseTmp.getDataId().startsWith(SAFE_CONFIG_PREFIX) && responseTmp.getContent() != null) {
                responseTmp.setContent(this.decrypt(responseTmp.getContent()));
            }
        }
        catch (ClientException e) {
            throw new DiamondException(500, "KMS error, errCode: " + e.getErrCode() + " ,errMsg: " + e.getErrMsg());
        }
    }

    private DefaultAcsClient kmsClient(String regionId, String accessKeyId, String accessKeySecret) {
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKeyId, accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient(profile);
        return client;
    }

    private DecryptResponse Decrypt(String cipherBlob) throws ClientException {
        DecryptRequest decReq = new DecryptRequest();
        decReq.setProtocol(ProtocolType.HTTPS);
        decReq.setAcceptFormat(FormatType.JSON);
        decReq.setMethod(MethodType.POST);
        decReq.setCiphertextBlob(cipherBlob);
        DecryptResponse decResponse = this.kmsClient.getAcsResponse(decReq);
        return decResponse;
    }

    public String decrypt(String cipherBlob) throws ClientException {
        DecryptResponse decResponse = this.Decrypt(cipherBlob);
        return decResponse.getPlaintext();
    }

    private EncryptResponse Encrypt(String keyId, String plainText) throws ClientException {
        EncryptRequest encReq = new EncryptRequest();
        encReq.setProtocol(ProtocolType.HTTPS);
        encReq.setAcceptFormat(FormatType.JSON);
        encReq.setMethod(MethodType.POST);
        encReq.setKeyId(keyId);
        encReq.setPlaintext(plainText);
        EncryptResponse encResponse = this.kmsClient.getAcsResponse(encReq);
        return encResponse;
    }

    private String encrypt(String keyId, String plainText) throws ClientException {
        EncryptResponse encResponse = this.Encrypt(keyId, plainText);
        return encResponse.getCiphertextBlob();
    }

    @Override
    public void init(IFilterConfig filterConfig) {
        this.keyId = (String)filterConfig.getInitParameter("keyId");
        String regionId = (String)filterConfig.getInitParameter("regionId");
        String accessKey = (String)filterConfig.getInitParameter("accessKey");
        String secretKey = (String)filterConfig.getInitParameter("secretKey");
        Object orderObject = filterConfig.getInitParameter("order");
        if (orderObject != null) {
            this.order = (Integer)orderObject;
        }
        this.kmsClient = this.kmsClient(regionId, accessKey, secretKey);
    }

    @Override
    public void deploy() {
        this.kmsClient = null;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getFilterName() {
        return this.getClass().getName();
    }
}

