/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.acm.shaded.com.aliyuncs.auth;

import com.alibaba.acm.shaded.com.aliyuncs.auth.BasicSessionCredentials;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class InstanceProfileCredentials
extends BasicSessionCredentials {
    private final long expiration;
    private final double expireFact = 0.9;
    private final long refreshIntervalInMillSeconds = 10000L;
    private long lastFailedRefreshTime = 0L;

    public InstanceProfileCredentials(String accessKeyId, String accessKeySecret, String sessionToken, String expiration, long roleSessionDurationSeconds) {
        super(accessKeyId, accessKeySecret, sessionToken, roleSessionDurationSeconds);
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parser.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = parser.parse(expiration.replace('T', ' ').replace('Z', ' '));
            this.expiration = date.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to get valid expiration time from ECS Metadata service.");
        }
    }

    @Override
    public boolean willSoonExpire() {
        long now = System.currentTimeMillis();
        return (double)this.roleSessionDurationSeconds * 0.09999999999999998 > (double)((this.expiration - now) / 1000L);
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        return now >= this.expiration - 10000L;
    }

    public boolean shouldRefresh() {
        long now = System.currentTimeMillis();
        return now - this.lastFailedRefreshTime > 10000L;
    }

    public void setLastFailedRefreshTime() {
        this.lastFailedRefreshTime = System.currentTimeMillis();
    }
}

