/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.edas.acm;

import com.alibaba.edas.acm.exception.ConfigException;
import com.alibaba.edas.acm.listener.ConfigChangeListenerAdapter;
import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.utils.JSONUtils;
import com.taobao.diamond.utils.MockUtil;
import com.taobao.spas.sdk.client.SpasSdkClientFacade;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;

public class ConfigService {
    public static void init(String endpoint, String namespace, String accessKey, String secretKey) {
        TlsUtil.changeTlsEnable((boolean)true);
        ServerHttpAgent.setDomainName((String)endpoint);
        TenantUtil.setUserTenant((String)namespace);
        SpasSdkClientFacade.getCredential().setAccessKey(accessKey);
        SpasSdkClientFacade.getCredential().setSecretKey(secretKey);
    }

    public static void init() {
        String namespace;
        TlsUtil.changeTlsEnable((boolean)true);
        String endpoint = System.getProperty("acm.endpoint", "");
        if (!endpoint.trim().isEmpty()) {
            ServerHttpAgent.setDomainName((String)endpoint);
        }
        if (!(namespace = System.getProperty("acm.namespace", "")).trim().isEmpty()) {
            TenantUtil.setUserTenant((String)namespace);
        }
        String debugStr = System.getProperty("acm.mock", "false");
        MockUtil.setMock((boolean)Boolean.valueOf(debugStr));
    }

    public static void setDebug(boolean isDebug) {
        MockUtil.setMock((boolean)isDebug);
    }

    public static void addListener(String dataId, String group, ConfigChangeListenerAdapter listener) {
        DiamondEnvRepo.defaultEnv.addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    public static void addGlobalListener(String dataId, String group, ConfigChangeListenerAdapter listener) {
        DiamondEnvRepo.defaultEnv.addListeners(dataId, group, Arrays.asList(listener));
    }

    public static String getConfig(String dataId, String group, long timeoutMs) throws ConfigException {
        try {
            return DiamondEnvRepo.defaultEnv.getTenantConfig(dataId, group, timeoutMs);
        }
        catch (DiamondException e) {
            throw new ConfigException(e.getErrCode(), e.getMessage());
        }
    }

    public static Properties getConfig2Properties(String dataId, String group, long timeoutMs) throws ConfigException {
        Properties properties = new Properties();
        try {
            String content = DiamondEnvRepo.defaultEnv.getTenantConfig(dataId, group, timeoutMs);
            try {
                properties.load(new StringReader(content));
            }
            catch (IOException e) {
                throw new ConfigException(e.getMessage());
            }
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getMessage());
        }
        return properties;
    }

    public static Object getConfig(String dataId, String group, long timeoutMs, Class<?> clazz) throws ConfigException {
        try {
            String jsonStr = DiamondEnvRepo.defaultEnv.getTenantConfig(dataId, group, timeoutMs);
            Object result = JSONUtils.deserializeObject((String)jsonStr, clazz);
            return result;
        }
        catch (IOException e) {
            throw new ConfigException(e.getMessage());
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getMessage());
        }
    }
}

