/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.context.WriteContextImpl;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.write.ExcelBuilder;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelBuilderImpl
implements ExcelBuilder {
    private WriteContext context;

    public ExcelBuilderImpl(WriteWorkbook writeWorkbook) {
        try {
            FileUtils.createPoiFilesDirectory();
            this.context = new WriteContextImpl(writeWorkbook);
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            this.finish();
            throw new ExcelGenerateException(e);
        }
    }

    private void doAddContent(List data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        WriteSheetHolder writeSheetHolder = this.context.writeSheetHolder();
        int newRowIndex = writeSheetHolder.getNewRowIndexAndStartDoWrite();
        if (writeSheetHolder.isNew() && !writeSheetHolder.getExcelWriteHeadProperty().hasHead()) {
            newRowIndex += this.context.currentWriteHolder().relativeHeadRowIndex();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (int relativeRowIndex = 0; relativeRowIndex < data.size(); ++relativeRowIndex) {
            int n = relativeRowIndex + newRowIndex;
            this.addOneRowOfDataToExcel(data.get(relativeRowIndex), n, relativeRowIndex, fieldList);
        }
    }

    @Override
    public void addContent(List data, WriteSheet writeSheet) {
        this.addContent(data, writeSheet, null);
    }

    @Override
    public void addContent(List data, WriteSheet writeSheet, WriteTable writeTable) {
        try {
            this.context.currentSheet(writeSheet);
            this.context.currentTable(writeTable);
            this.doAddContent(data);
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            this.finish();
            throw new ExcelGenerateException(e);
        }
    }

    @Override
    public void finish() {
        if (this.context != null) {
            this.context.finish();
        }
    }

    @Override
    public void merge(int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.context.writeSheetHolder().getSheet().addMergedRegion(cra);
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n, int relativeRowIndex, List<Field> fieldList) {
        this.beforeRowCreate(n, relativeRowIndex);
        Row row = WorkBookUtil.createRow(this.context.writeSheetHolder().getSheet(), n);
        this.afterRowCreate(row, relativeRowIndex);
        if (oneRowData instanceof List) {
            this.addBasicTypeToExcel((List)oneRowData, row, relativeRowIndex);
        } else {
            this.addJavaObjectToExcel(oneRowData, row, relativeRowIndex, fieldList);
        }
    }

    private void beforeRowCreate(int rowIndex, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.context.currentWriteHolder().writeHandlerMap().get(RowWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof RowWriteHandler)) continue;
            ((RowWriteHandler)writeHandler).beforeRowCreate(this.context.writeSheetHolder(), this.context.writeTableHolder(), rowIndex, relativeRowIndex, false);
        }
    }

    private void afterRowCreate(Row row, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.context.currentWriteHolder().writeHandlerMap().get(RowWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof RowWriteHandler)) continue;
            ((RowWriteHandler)writeHandler).afterRowCreate(this.context.writeSheetHolder(), this.context.writeTableHolder(), row, relativeRowIndex, false);
        }
        if (null != this.context.writeWorkbookHolder().getWriteWorkbook().getWriteHandler()) {
            this.context.writeWorkbookHolder().getWriteWorkbook().getWriteHandler().row(row.getRowNum(), row);
        }
    }

    private void addBasicTypeToExcel(List<Object> oneRowData, Row row, int relativeRowIndex) {
        if (CollectionUtils.isEmpty(oneRowData)) {
            return;
        }
        Map<Integer, Head> headMap = this.context.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
        int dataIndex = 0;
        int cellIndex = 0;
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            if (dataIndex >= oneRowData.size()) {
                return;
            }
            cellIndex = entry.getKey();
            Head head = entry.getValue();
            this.doAddBasicTypeToExcel(oneRowData, head, row, relativeRowIndex, dataIndex++, cellIndex);
        }
        if (dataIndex >= oneRowData.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        int size = oneRowData.size() - dataIndex;
        for (int i = 0; i < size; ++i) {
            this.doAddBasicTypeToExcel(oneRowData, null, row, relativeRowIndex, dataIndex++, cellIndex++);
        }
    }

    private void doAddBasicTypeToExcel(List<Object> oneRowData, Head head, Row row, int relativeRowIndex, int dataIndex, int cellIndex) {
        this.beforeCellCreate(row, head, relativeRowIndex);
        Cell cell = WorkBookUtil.createCell(row, cellIndex);
        Object value = oneRowData.get(dataIndex);
        CellData cellData = this.converterAndSet(this.context.currentWriteHolder(), value == null ? null : value.getClass(), cell, value, null);
        this.afterCellCreate(head, cellData, cell, relativeRowIndex);
    }

    private void addJavaObjectToExcel(Object oneRowData, Row row, int relativeRowIndex, List<Field> fieldList) {
        WriteHolder currentWriteHolder = this.context.currentWriteHolder();
        BeanMap beanMap = BeanMap.create((Object)oneRowData);
        HashSet<String> beanMapHandledSet = new HashSet<String>();
        int cellIndex = 0;
        if (HeadKindEnum.CLASS.equals((Object)this.context.currentWriteHolder().excelWriteHeadProperty().getHeadKind())) {
            Map<Integer, Head> headMap = this.context.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
            Map<Integer, ExcelContentProperty> contentPropertyMap = this.context.currentWriteHolder().excelWriteHeadProperty().getContentPropertyMap();
            for (Map.Entry<Integer, ExcelContentProperty> entry : contentPropertyMap.entrySet()) {
                cellIndex = entry.getKey();
                ExcelContentProperty excelContentProperty = entry.getValue();
                String name = excelContentProperty.getField().getName();
                if (!beanMap.containsKey((Object)name)) continue;
                Head head = headMap.get(cellIndex);
                this.beforeCellCreate(row, head, relativeRowIndex);
                Cell cell = WorkBookUtil.createCell(row, cellIndex);
                Object value = beanMap.get((Object)name);
                CellData cellData = this.converterAndSet(currentWriteHolder, excelContentProperty.getField().getType(), cell, value, excelContentProperty);
                this.afterCellCreate(head, cellData, cell, relativeRowIndex);
                beanMapHandledSet.add(name);
            }
        }
        if (beanMapHandledSet.size() == beanMap.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        Map<String, Field> ignoreMap = this.context.currentWriteHolder().excelWriteHeadProperty().getIgnoreMap();
        this.initFieldList(oneRowData.getClass(), fieldList);
        for (Field field : fieldList) {
            Object value;
            String filedName = field.getName();
            boolean uselessData = !beanMap.containsKey((Object)filedName) || beanMapHandledSet.contains(filedName) || ignoreMap.containsKey(filedName);
            if (uselessData || (value = beanMap.get((Object)filedName)) == null) continue;
            this.beforeCellCreate(row, null, relativeRowIndex);
            Cell cell = WorkBookUtil.createCell(row, cellIndex++);
            CellData cellData = this.converterAndSet(currentWriteHolder, value.getClass(), cell, value, null);
            this.afterCellCreate(null, cellData, cell, relativeRowIndex);
        }
    }

    private void initFieldList(Class clazz, List<Field> fieldList) {
        if (!fieldList.isEmpty()) {
            return;
        }
        for (Class tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            if (tempClass == BaseRowModel.class) continue;
            Collections.addAll(fieldList, tempClass.getDeclaredFields());
        }
    }

    private void beforeCellCreate(Row row, Head head, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.context.currentWriteHolder().writeHandlerMap().get(CellWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof CellWriteHandler)) continue;
            ((CellWriteHandler)writeHandler).beforeCellCreate(this.context.writeSheetHolder(), this.context.writeTableHolder(), row, head, relativeRowIndex, false);
        }
    }

    private void afterCellCreate(Head head, CellData cellData, Cell cell, int relativeRowIndex) {
        List<WriteHandler> handlerList = this.context.currentWriteHolder().writeHandlerMap().get(CellWriteHandler.class);
        if (handlerList == null || handlerList.isEmpty()) {
            return;
        }
        for (WriteHandler writeHandler : handlerList) {
            if (!(writeHandler instanceof CellWriteHandler)) continue;
            ((CellWriteHandler)writeHandler).afterCellCreate(this.context.writeSheetHolder(), this.context.writeTableHolder(), cellData, cell, head, relativeRowIndex, false);
        }
        if (null != this.context.writeWorkbookHolder().getWriteWorkbook().getWriteHandler()) {
            this.context.writeWorkbookHolder().getWriteWorkbook().getWriteHandler().cell(cell.getRowIndex(), cell);
        }
    }

    private CellData converterAndSet(WriteHolder currentWriteHolder, Class clazz, Cell cell, Object value, ExcelContentProperty excelContentProperty) {
        CellData cellData;
        if (value == null) {
            return null;
        }
        if (value instanceof String && currentWriteHolder.globalConfiguration().getAutoTrim().booleanValue()) {
            value = ((String)value).trim();
        }
        if ((cellData = this.convert(currentWriteHolder, clazz, cell, value, excelContentProperty)) == null || cellData.getType() == null) {
            throw new ExcelDataConvertException("Convert data:" + value + " return null,at row:" + cell.getRow().getRowNum());
        }
        if (cellData.getFormula() != null && cellData.getFormula().booleanValue()) {
            cell.setCellFormula(cellData.getFormulaValue());
        }
        switch (cellData.getType()) {
            case STRING: {
                cell.setCellValue(cellData.getStringValue());
                return cellData;
            }
            case BOOLEAN: {
                cell.setCellValue(cellData.getBooleanValue().booleanValue());
                return cellData;
            }
            case NUMBER: {
                cell.setCellValue(cellData.getNumberValue().doubleValue());
                return cellData;
            }
            case IMAGE: {
                this.setImageValue(cellData, cell);
                return cellData;
            }
        }
        throw new ExcelDataConvertException("Not supported data:" + value + " return type:" + cell.getCellType() + "at row:" + cell.getRow().getRowNum());
    }

    private void setImageValue(CellData cellData, Cell cell) {
        Sheet sheet = cell.getSheet();
        int index = sheet.getWorkbook().addPicture(cellData.getImageValue(), 6);
        Drawing drawing = sheet.getDrawingPatriarch();
        if (drawing == null) {
            drawing = sheet.createDrawingPatriarch();
        }
        CreationHelper helper = sheet.getWorkbook().getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 1);
        anchor.setRow1(cell.getRowIndex());
        anchor.setRow2(cell.getRowIndex() + 1);
        anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
        drawing.createPicture(anchor, index);
    }

    private CellData convert(WriteHolder currentWriteHolder, Class clazz, Cell cell, Object value, ExcelContentProperty excelContentProperty) {
        CellData cellData;
        if (value instanceof CellData) {
            return (CellData)value;
        }
        Converter converter = null;
        if (excelContentProperty != null) {
            converter = excelContentProperty.getConverter();
        }
        if (converter == null) {
            converter = currentWriteHolder.converterMap().get(ConverterKeyBuild.buildKey(clazz));
        }
        if (converter == null) {
            throw new ExcelDataConvertException("Can not find 'Converter' support class " + clazz.getSimpleName() + ".");
        }
        try {
            cellData = converter.convertToExcelData(value, excelContentProperty, currentWriteHolder.globalConfiguration());
        }
        catch (Exception e) {
            throw new ExcelDataConvertException("Convert data:" + value + " error,at row:" + cell.getRow().getRowNum(), e);
        }
        return cellData;
    }
}

