/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.sql.ROWID;

public class OracleUtils {
    private static final Log LOG = LogFactory.getLog(OracleUtils.class);
    private static Set<String> builtinFunctions;
    private static Set<String> builtinTables;
    private static Set<String> keywords;

    public static XAConnection OracleXAConnection(Connection oracleConnection) throws XAException {
        return new OracleXAConnection(oracleConnection);
    }

    public static int getRowPrefetch(PreparedStatement stmt) throws SQLException {
        OracleStatement oracleStmt = stmt.unwrap(OracleStatement.class);
        if (oracleStmt == null) {
            return -1;
        }
        return oracleStmt.getRowPrefetch();
    }

    public static void setRowPrefetch(PreparedStatement stmt, int value) throws SQLException {
        OracleStatement oracleStmt = stmt.unwrap(OracleStatement.class);
        if (oracleStmt != null) {
            oracleStmt.setRowPrefetch(value);
        }
    }

    public static void enterImplicitCache(PreparedStatement stmt) throws SQLException {
        OraclePreparedStatement oracleStmt = OracleUtils.unwrapInternal(stmt);
        if (oracleStmt != null) {
            oracleStmt.enterImplicitCache();
        }
    }

    public static void exitImplicitCacheToClose(PreparedStatement stmt) throws SQLException {
        OraclePreparedStatement oracleStmt = OracleUtils.unwrapInternal(stmt);
        if (oracleStmt != null) {
            oracleStmt.exitImplicitCacheToClose();
        }
    }

    public static void exitImplicitCacheToActive(PreparedStatement stmt) throws SQLException {
        OraclePreparedStatement oracleStmt = OracleUtils.unwrapInternal(stmt);
        if (oracleStmt != null) {
            oracleStmt.exitImplicitCacheToActive();
        }
    }

    public static OraclePreparedStatement unwrapInternal(PreparedStatement stmt) throws SQLException {
        if (stmt instanceof OraclePreparedStatement) {
            return (OraclePreparedStatement)stmt;
        }
        OraclePreparedStatement unwrapped = stmt.unwrap(OraclePreparedStatement.class);
        if (unwrapped == null) {
            LOG.error("can not unwrap statement : " + stmt.getClass());
        }
        return unwrapped;
    }

    public static short getVersionNumber(DruidPooledConnection conn) throws SQLException {
        OracleConnection oracleConn = (OracleConnection)OracleUtils.unwrap(conn);
        return oracleConn.getVersionNumber();
    }

    public static void setDefaultRowPrefetch(Connection conn, int value) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        oracleConn.setDefaultRowPrefetch(value);
    }

    public static int getDefaultRowPrefetch(Connection conn, int value) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        return oracleConn.getDefaultRowPrefetch();
    }

    public static boolean getImplicitCachingEnabled(Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        return oracleConn.getImplicitCachingEnabled();
    }

    public static int getStatementCacheSize(Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        return oracleConn.getStatementCacheSize();
    }

    public static void purgeImplicitCache(Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        oracleConn.purgeImplicitCache();
    }

    public static void setImplicitCachingEnabled(Connection conn, boolean cache) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        oracleConn.setImplicitCachingEnabled(cache);
    }

    public static void setStatementCacheSize(Connection conn, int size) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        oracleConn.setStatementCacheSize(size);
    }

    public static int pingDatabase(Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        return oracleConn.pingDatabase();
    }

    public static void openProxySession(Connection conn, int type, Properties prop) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        oracleConn.openProxySession(type, prop);
    }

    public static int getDefaultExecuteBatch(Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection oracleConn = OracleUtils.unwrap(conn);
        return oracleConn.getDefaultExecuteBatch();
    }

    public static oracle.jdbc.OracleConnection unwrap(Connection conn) throws SQLException {
        if (conn instanceof oracle.jdbc.OracleConnection) {
            return (oracle.jdbc.OracleConnection)conn;
        }
        return conn.unwrap(oracle.jdbc.OracleConnection.class);
    }

    public static ROWID getROWID(ResultSet rs, int columnIndex) throws SQLException {
        OracleResultSet oracleResultSet = rs.unwrap(OracleResultSet.class);
        return oracleResultSet.getROWID(columnIndex);
    }

    public static boolean isBuiltinFunction(String function) {
        if (function == null) {
            return false;
        }
        String function_lower = function.toLowerCase();
        Set<String> functions = builtinFunctions;
        if (functions == null) {
            functions = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/oracle/builtin_functions", functions);
            builtinFunctions = functions;
        }
        return functions.contains(function_lower);
    }

    public static boolean isBuiltinTable(String table) {
        if (table == null) {
            return false;
        }
        String table_lower = table.toLowerCase();
        Set<String> tables = builtinTables;
        if (tables == null) {
            tables = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/oracle/builtin_tables", tables);
            builtinTables = tables;
        }
        return tables.contains(table_lower);
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        String name_lower = name.toLowerCase();
        Set<String> words = keywords;
        if (words == null) {
            words = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/oracle/keywords", words);
            keywords = words;
        }
        return words.contains(name_lower);
    }
}

