/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.common.param;

import com.taobao.spas.sdk.common.param.ParamNode;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedParamList
extends ArrayList<ParamNode> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean add(ParamNode e) {
        if (this.size() == 0) {
            return super.add(e);
        }
        return this.binaryAdd(e, 0, this.size() - 1);
    }

    private boolean binaryAdd(ParamNode e, int start, int end) {
        if (start > end) {
            super.add(start, e);
            return true;
        }
        if (start == end) {
            if (e.compareTo((ParamNode)this.get(start)) <= 0) {
                super.add(start, e);
            } else {
                super.add(start + 1, e);
            }
            return true;
        }
        int mid = (start + end) / 2;
        int cmp = e.compareTo((ParamNode)this.get(mid));
        if (cmp < 0) {
            return this.binaryAdd(e, start, mid - 1);
        }
        if (cmp > 0) {
            return this.binaryAdd(e, mid + 1, end);
        }
        super.add(mid, e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ParamNode> c) {
        for (ParamNode paramNode : c) {
            this.add(paramNode);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.size() > 0) {
            sb.append(((ParamNode)this.get(0)).toString());
        }
        for (int i = 1; i < this.size(); ++i) {
            sb.append("&" + ((ParamNode)this.get(i)).toString());
        }
        return sb.toString();
    }

    public String toRawString() {
        StringBuilder sb = new StringBuilder();
        for (ParamNode e : this) {
            sb.append(e.toRawString());
        }
        return sb.toString();
    }
}

