/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.embeddings;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextEmbeddingParam
extends HalfDuplexServiceParam {
    private List<String> texts;
    private TextType textType;
    private Integer dimension;
    private OutputType outputType;
    private String instruct;

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.textType != null) {
            params.put("text_type", this.textType.getValue());
        }
        if (this.dimension != null) {
            params.put("dimension", this.dimension);
        }
        if (this.outputType != null) {
            params.put("output_type", this.outputType.getValue());
        }
        if (this.instruct != null) {
            params.put("instruct", this.instruct);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            params.putAll(this.parameters);
        }
        return params;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        if (this.getParameters() != null && !this.getParameters().isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.getParameters()));
        }
        return requestObject;
    }

    public JsonObject getInput() {
        JsonObject input = new JsonObject();
        input.add("texts", (JsonElement)JsonUtils.toJsonArray(this.texts));
        return input;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.texts.isEmpty()) {
            throw new InputRequiredException("texts must not empty");
        }
    }

    protected TextEmbeddingParam(TextEmbeddingParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        List<Object> texts;
        switch (((TextEmbeddingParamBuilder)b).texts == null ? 0 : ((TextEmbeddingParamBuilder)b).texts.size()) {
            case 0: {
                texts = Collections.emptyList();
                break;
            }
            case 1: {
                texts = Collections.singletonList(((TextEmbeddingParamBuilder)b).texts.get(0));
                break;
            }
            default: {
                texts = Collections.unmodifiableList(new ArrayList(((TextEmbeddingParamBuilder)b).texts));
            }
        }
        this.texts = texts;
        this.textType = ((TextEmbeddingParamBuilder)b).textType;
        this.dimension = ((TextEmbeddingParamBuilder)b).dimension;
        this.outputType = ((TextEmbeddingParamBuilder)b).outputType;
        this.instruct = ((TextEmbeddingParamBuilder)b).instruct;
    }

    public static TextEmbeddingParamBuilder<?, ?> builder() {
        return new TextEmbeddingParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextEmbeddingParam)) {
            return false;
        }
        TextEmbeddingParam other = (TextEmbeddingParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$dimension = this.dimension;
        Integer other$dimension = other.dimension;
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        List<String> this$texts = this.texts;
        List<String> other$texts = other.texts;
        if (this$texts == null ? other$texts != null : !((Object)this$texts).equals(other$texts)) {
            return false;
        }
        TextType this$textType = this.textType;
        TextType other$textType = other.textType;
        if (this$textType == null ? other$textType != null : !((Object)((Object)this$textType)).equals((Object)other$textType)) {
            return false;
        }
        OutputType this$outputType = this.outputType;
        OutputType other$outputType = other.outputType;
        if (this$outputType == null ? other$outputType != null : !((Object)((Object)this$outputType)).equals((Object)other$outputType)) {
            return false;
        }
        String this$instruct = this.instruct;
        String other$instruct = other.instruct;
        return !(this$instruct == null ? other$instruct != null : !this$instruct.equals(other$instruct));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextEmbeddingParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dimension = this.dimension;
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        List<String> $texts = this.texts;
        result = result * 59 + ($texts == null ? 43 : ((Object)$texts).hashCode());
        TextType $textType = this.textType;
        result = result * 59 + ($textType == null ? 43 : ((Object)((Object)$textType)).hashCode());
        OutputType $outputType = this.outputType;
        result = result * 59 + ($outputType == null ? 43 : ((Object)((Object)$outputType)).hashCode());
        String $instruct = this.instruct;
        result = result * 59 + ($instruct == null ? 43 : $instruct.hashCode());
        return result;
    }

    private static final class TextEmbeddingParamBuilderImpl
    extends TextEmbeddingParamBuilder<TextEmbeddingParam, TextEmbeddingParamBuilderImpl> {
        private TextEmbeddingParamBuilderImpl() {
        }

        @Override
        protected TextEmbeddingParamBuilderImpl self() {
            return this;
        }

        @Override
        public TextEmbeddingParam build() {
            return new TextEmbeddingParam(this);
        }
    }

    public static abstract class TextEmbeddingParamBuilder<C extends TextEmbeddingParam, B extends TextEmbeddingParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private ArrayList<String> texts;
        private TextType textType;
        private Integer dimension;
        private OutputType outputType;
        private String instruct;

        public B text(String text) {
            if (this.texts == null) {
                this.texts = new ArrayList();
            }
            this.texts.add(text);
            return (B)this.self();
        }

        public B texts(Collection<? extends String> texts) {
            if (texts == null) {
                throw new NullPointerException("texts cannot be null");
            }
            if (this.texts == null) {
                this.texts = new ArrayList();
            }
            this.texts.addAll(texts);
            return (B)this.self();
        }

        public B clearTexts() {
            if (this.texts != null) {
                this.texts.clear();
            }
            return (B)this.self();
        }

        public B textType(TextType textType) {
            this.textType = textType;
            return (B)this.self();
        }

        public B dimension(Integer dimension) {
            this.dimension = dimension;
            return (B)this.self();
        }

        public B outputType(OutputType outputType) {
            this.outputType = outputType;
            return (B)this.self();
        }

        public B instruct(String instruct) {
            this.instruct = instruct;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TextEmbeddingParam.TextEmbeddingParamBuilder(super=" + super.toString() + ", texts=" + this.texts + ", textType=" + (Object)((Object)this.textType) + ", dimension=" + this.dimension + ", outputType=" + (Object)((Object)this.outputType) + ", instruct=" + this.instruct + ")";
        }
    }

    public static enum OutputType {
        DENSE("dense"),
        SPARSE("sparse"),
        DENSE_AND_SPARSE("dense&sparse");

        private final String value;

        private OutputType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TextType {
        QUERY("query"),
        DOCUMENT("document");

        private final String value;

        private TextType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

