/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.runs;

import com.alibaba.dashscope.api.GeneralApi;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.FlattenResultBase;
import com.alibaba.dashscope.common.GeneralGetParam;
import com.alibaba.dashscope.common.GeneralListParam;
import com.alibaba.dashscope.common.ListResult;
import com.alibaba.dashscope.common.UpdateMetadataParam;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.InvalidateParameter;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.GeneralServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.threads.runs.AssistantEventHandler;
import com.alibaba.dashscope.threads.runs.AssistantStreamMessage;
import com.alibaba.dashscope.threads.runs.Run;
import com.alibaba.dashscope.threads.runs.RunParam;
import com.alibaba.dashscope.threads.runs.RunStep;
import com.alibaba.dashscope.threads.runs.StreamEventProcessingCallback;
import com.alibaba.dashscope.threads.runs.SubmitToolOutputsParam;
import com.alibaba.dashscope.threads.runs.ThreadAndRunParam;
import com.google.gson.reflect.TypeToken;
import io.reactivex.Flowable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class Runs {
    private final GeneralApi<HalfDuplexParamBase> api;
    private final GeneralServiceOption serviceOption = this.defaultServiceOption();

    private GeneralServiceOption defaultServiceOption() {
        return ((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)GeneralServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).path("assistants")).build();
    }

    public Runs() {
        this.api = new GeneralApi();
    }

    public Runs(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption.setBaseHttpUrl(baseUrl);
        this.api = new GeneralApi(connectionOptions);
    }

    public Run create(String threadId, RunParam param) throws ApiException, NoApiKeyException, InputRequiredException, InvalidateParameter {
        if (threadId == null || threadId.equals("")) {
            throw new InputRequiredException("threadId is required!");
        }
        if (param.getStream().booleanValue()) {
            throw new InvalidateParameter("Request with stream=true should use createStream");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs", threadId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (Run)FlattenResultBase.fromDashScopeResult(result, Run.class);
    }

    public Flowable<AssistantStreamMessage> createStream(String threadId, RunParam param) throws ApiException, NoApiKeyException, InputRequiredException, InvalidateParameter {
        if (threadId == null || threadId.equals("")) {
            throw new InputRequiredException("threadId is required!");
        }
        if (!param.getStream().booleanValue()) {
            throw new InvalidateParameter("Request with stream=false should use create");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs", threadId));
        Flowable<DashScopeResult> result = this.api.streamCall(param, this.serviceOption);
        return result.map(item -> FlattenResultBase.fromDashScopeResult(item, AssistantStreamMessage.class, true));
    }

    public void createStream(String threadId, RunParam param, AssistantEventHandler handler) throws ApiException, NoApiKeyException, InputRequiredException, InvalidateParameter {
        if (threadId == null || threadId.equals("")) {
            throw new InputRequiredException("threadId is required!");
        }
        if (!param.getStream().booleanValue()) {
            throw new InvalidateParameter("Request with stream=false should use create");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs", threadId));
        this.api.streamCall(param, this.serviceOption, new StreamEventProcessingCallback(handler));
    }

    public Run createThreadAndRun(ThreadAndRunParam param) throws ApiException, NoApiKeyException, InvalidateParameter {
        if (param.getStream().booleanValue()) {
            throw new InvalidateParameter("Request with stream=false should use create");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/runs", new Object[0]));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (Run)FlattenResultBase.fromDashScopeResult(result, Run.class);
    }

    public Flowable<AssistantStreamMessage> createStreamThreadAndRun(ThreadAndRunParam param) throws ApiException, NoApiKeyException, InvalidateParameter {
        if (!param.getStream().booleanValue()) {
            throw new InvalidateParameter("Request with stream=false should use create");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/runs", new Object[0]));
        return this.api.streamCall(param, this.serviceOption).map(dashscopeResult -> FlattenResultBase.fromDashScopeResult(dashscopeResult, AssistantStreamMessage.class, true));
    }

    public void createStreamThreadAndRun(ThreadAndRunParam param, AssistantEventHandler handler) throws ApiException, NoApiKeyException, InvalidateParameter {
        if (!param.getStream().booleanValue()) {
            throw new InvalidateParameter("Request with stream=false should use create");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/runs", new Object[0]));
        this.api.streamCall(param, this.serviceOption, new StreamEventProcessingCallback(handler));
    }

    public Run update(String threadId, String runId, UpdateMetadataParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.equals("") || runId == null || runId.isEmpty()) {
            throw new InputRequiredException("threadId and runId are required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s", threadId, runId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (Run)FlattenResultBase.fromDashScopeResult(result, Run.class);
    }

    public ListResult<Run> list(String threadId, GeneralListParam listParam) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/runs", threadId));
        DashScopeResult result = this.api.get(listParam, this.serviceOption);
        Type typeOfT = new TypeToken<ListResult<Run>>(){}.getType();
        return (ListResult)FlattenResultBase.fromDashScopeResult(result, typeOfT);
    }

    public ListResult<RunStep> listSteps(String threadId, String runId, GeneralListParam listParam) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s/steps", threadId, runId));
        DashScopeResult result = this.api.get(listParam, this.serviceOption);
        Type typeOfT = new TypeToken<ListResult<RunStep>>(){}.getType();
        return (ListResult)FlattenResultBase.fromDashScopeResult(result, typeOfT);
    }

    public Run retrieve(String threadId, String runId) throws ApiException, NoApiKeyException {
        return this.retrieve(threadId, runId, null);
    }

    public Run retrieve(String threadId, String runId, String apiKey) throws ApiException, NoApiKeyException {
        return this.retrieve(threadId, runId, apiKey, new HashMap<String, String>());
    }

    public Run retrieve(String threadId, String runId, String apiKey, Map<String, String> headers) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s", threadId, runId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().headers(headers)).apiKey(apiKey)).build(), this.serviceOption);
        return (Run)FlattenResultBase.fromDashScopeResult(result, Run.class);
    }

    public RunStep retrieveStep(String threadId, String runId, String stepId) throws ApiException, NoApiKeyException {
        return this.retrieveStep(threadId, runId, stepId, null);
    }

    public RunStep retrieveStep(String threadId, String runId, String stepId, String apiKey) throws ApiException, NoApiKeyException {
        return this.retrieveStep(threadId, runId, stepId, apiKey, new HashMap<String, String>());
    }

    public RunStep retrieveStep(String threadId, String runId, String stepId, String apiKey, Map<String, String> headers) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s/steps/%s", threadId, runId, stepId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().headers(headers)).apiKey(apiKey)).build(), this.serviceOption);
        return (RunStep)FlattenResultBase.fromDashScopeResult(result, RunStep.class);
    }

    public Run submitToolOutputs(String threadId, String runId, SubmitToolOutputsParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.equals("") || runId == null || runId.isEmpty()) {
            throw new InputRequiredException("threadId and runId are required!");
        }
        param.validate();
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s/submit_tool_outputs", threadId, runId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (Run)FlattenResultBase.fromDashScopeResult(result, Run.class);
    }

    public Flowable<AssistantStreamMessage> submitStreamToolOutputs(String threadId, String runId, SubmitToolOutputsParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.equals("") || runId == null || runId.isEmpty()) {
            throw new InputRequiredException("threadId and runId are required!");
        }
        param.validate();
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s/submit_tool_outputs", threadId, runId));
        return this.api.streamCall(param, this.serviceOption).map(dashscopeResult -> FlattenResultBase.fromDashScopeResult(dashscopeResult, AssistantStreamMessage.class, true));
    }

    public void submitStreamToolOutputs(String threadId, String runId, SubmitToolOutputsParam param, AssistantEventHandler handler) throws ApiException, NoApiKeyException, InputRequiredException {
        if (threadId == null || threadId.equals("") || runId == null || runId.isEmpty()) {
            throw new InputRequiredException("threadId and runId are required!");
        }
        param.validate();
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("threads/%s/runs/%s/submit_tool_outputs", threadId, runId));
        this.api.streamCall(param, this.serviceOption, new StreamEventProcessingCallback(handler));
    }
}

