/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.runs;

import com.alibaba.dashscope.threads.AssistantThread;
import com.alibaba.dashscope.threads.messages.ThreadMessage;
import com.alibaba.dashscope.threads.runs.AssistantEventHandler;
import com.alibaba.dashscope.threads.runs.LastError;
import com.alibaba.dashscope.threads.runs.Run;
import com.alibaba.dashscope.threads.runs.RunStep;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;

public class DefaultAssistantEventHandler
implements AssistantEventHandler {
    private AssistantThread assistantThread;
    private Run run;
    private RunStep finalRunStep;
    private ThreadMessage finalMessage;
    private LastError error;
    private boolean isCompleted = false;
    private FlowableEmitter<ThreadMessage> threadMessageEmitter;
    private Flowable<ThreadMessage> threadMessageFlowable = Flowable.create(emitter -> {
        this.threadMessageEmitter = emitter;
    }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    private FlowableEmitter<RunStep> runStepEmitter;
    private Flowable<RunStep> runStepFlowable;

    public DefaultAssistantEventHandler() {
        this.threadMessageFlowable.subscribe().dispose();
        this.runStepFlowable = Flowable.create(emitter -> {
            this.runStepEmitter = emitter;
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        this.runStepFlowable.subscribe().dispose();
    }

    public Flowable<ThreadMessage> getStreamMessage() {
        return this.threadMessageFlowable;
    }

    public Flowable<RunStep> getRunStepDelta() {
        return this.runStepFlowable;
    }

    public synchronized void await() throws InterruptedException {
        while (!this.isCompleted) {
            this.wait();
        }
    }

    public synchronized void signal() {
        this.isCompleted = true;
        this.notifyAll();
    }

    @Override
    public void onThreadCreated(AssistantThread thread) {
        this.assistantThread = thread;
    }

    @Override
    public void onThreadRunCreated(Run run) {
        this.run = run;
    }

    @Override
    public void onThreadRunQueued(Run run) {
        this.run = run;
    }

    @Override
    public void onThreadRunInProgress(Run run) {
        this.run = run;
    }

    @Override
    public void onThreadRunRequiresAction(Run run) {
        this.run = run;
        this.signal();
    }

    @Override
    public void onThreadRunCompleted(Run run) {
        this.run = run;
        this.signal();
    }

    @Override
    public void onThreadRunFailed(Run run) {
        this.run = run;
        this.signal();
    }

    @Override
    public void onThreadRunCancelling(Run run) {
        this.run = run;
    }

    @Override
    public void onThreadRunCancelled(Run run) {
        this.run = run;
        this.signal();
    }

    @Override
    public void onThreadRunExpired(Run run) {
        this.run = run;
        this.signal();
    }

    @Override
    public void OnThreadRunStepCreated(RunStep runStep) {
        this.finalRunStep = runStep;
    }

    @Override
    public void OnThreadRunStepInProgress(RunStep runStep) {
        this.finalRunStep = runStep;
    }

    @Override
    public void OnThreadRunStepDelta(RunStep runStep) {
        this.runStepEmitter.onNext((Object)runStep);
    }

    @Override
    public void OnThreadRunStepCompleted(RunStep runStep) {
        this.finalRunStep = runStep;
        this.runStepEmitter.onComplete();
    }

    @Override
    public void OnThreadRunStepFailed(RunStep runStep) {
        this.finalRunStep = runStep;
        this.runStepEmitter.onNext((Object)runStep);
        this.runStepEmitter.onComplete();
    }

    @Override
    public void OnThreadRunStepCancelled(RunStep runStep) {
        this.finalRunStep = runStep;
        this.runStepEmitter.onComplete();
    }

    @Override
    public void OnThreadRunStepExpired(RunStep runStep) {
        this.finalRunStep = runStep;
        this.runStepEmitter.onComplete();
    }

    @Override
    public void onThreadMessageCreated(ThreadMessage threadMessage) {
        this.finalMessage = threadMessage;
    }

    @Override
    public void onThreadMessageInProgress(ThreadMessage threadMessage) {
        this.finalMessage = threadMessage;
    }

    @Override
    public void onThreadMessageDelta(ThreadMessage threadMessage) {
        this.threadMessageEmitter.onNext((Object)threadMessage);
    }

    @Override
    public void onThreadMessageCompleted(ThreadMessage threadMessage) {
        this.finalMessage = threadMessage;
        this.threadMessageEmitter.onNext((Object)threadMessage);
        this.threadMessageEmitter.onComplete();
    }

    @Override
    public void onThreadMessageIncomplete(ThreadMessage threadMessage) {
        this.finalMessage = threadMessage;
        this.threadMessageEmitter.onNext((Object)threadMessage);
        this.threadMessageEmitter.onComplete();
    }

    @Override
    public void onError(String errorMsg) {
        this.signal();
    }

    @Override
    public void onUnknown(String msg) {
        System.out.println(msg);
    }

    @Override
    public void onDone() {
        this.threadMessageEmitter.onComplete();
        this.runStepEmitter.onComplete();
        this.signal();
    }

    public AssistantThread getAssistantThread() {
        return this.assistantThread;
    }

    public Run getRun() {
        return this.run;
    }

    public RunStep getFinalRunStep() {
        return this.finalRunStep;
    }

    public ThreadMessage getFinalMessage() {
        return this.finalMessage;
    }

    public LastError getError() {
        return this.error;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public FlowableEmitter<ThreadMessage> getThreadMessageEmitter() {
        return this.threadMessageEmitter;
    }

    public Flowable<ThreadMessage> getThreadMessageFlowable() {
        return this.threadMessageFlowable;
    }

    public FlowableEmitter<RunStep> getRunStepEmitter() {
        return this.runStepEmitter;
    }

    public Flowable<RunStep> getRunStepFlowable() {
        return this.runStepFlowable;
    }

    public void setAssistantThread(AssistantThread assistantThread) {
        this.assistantThread = assistantThread;
    }

    public void setRun(Run run) {
        this.run = run;
    }

    public void setFinalRunStep(RunStep finalRunStep) {
        this.finalRunStep = finalRunStep;
    }

    public void setFinalMessage(ThreadMessage finalMessage) {
        this.finalMessage = finalMessage;
    }

    public void setError(LastError error) {
        this.error = error;
    }

    public void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public void setThreadMessageEmitter(FlowableEmitter<ThreadMessage> threadMessageEmitter) {
        this.threadMessageEmitter = threadMessageEmitter;
    }

    public void setThreadMessageFlowable(Flowable<ThreadMessage> threadMessageFlowable) {
        this.threadMessageFlowable = threadMessageFlowable;
    }

    public void setRunStepEmitter(FlowableEmitter<RunStep> runStepEmitter) {
        this.runStepEmitter = runStepEmitter;
    }

    public void setRunStepFlowable(Flowable<RunStep> runStepFlowable) {
        this.runStepFlowable = runStepFlowable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAssistantEventHandler)) {
            return false;
        }
        DefaultAssistantEventHandler other = (DefaultAssistantEventHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        AssistantThread this$assistantThread = this.getAssistantThread();
        AssistantThread other$assistantThread = other.getAssistantThread();
        if (this$assistantThread == null ? other$assistantThread != null : !((Object)this$assistantThread).equals(other$assistantThread)) {
            return false;
        }
        Run this$run = this.getRun();
        Run other$run = other.getRun();
        if (this$run == null ? other$run != null : !((Object)this$run).equals(other$run)) {
            return false;
        }
        RunStep this$finalRunStep = this.getFinalRunStep();
        RunStep other$finalRunStep = other.getFinalRunStep();
        if (this$finalRunStep == null ? other$finalRunStep != null : !((Object)this$finalRunStep).equals(other$finalRunStep)) {
            return false;
        }
        ThreadMessage this$finalMessage = this.getFinalMessage();
        ThreadMessage other$finalMessage = other.getFinalMessage();
        if (this$finalMessage == null ? other$finalMessage != null : !((Object)this$finalMessage).equals(other$finalMessage)) {
            return false;
        }
        LastError this$error = this.getError();
        LastError other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        FlowableEmitter<ThreadMessage> this$threadMessageEmitter = this.getThreadMessageEmitter();
        FlowableEmitter<ThreadMessage> other$threadMessageEmitter = other.getThreadMessageEmitter();
        if (this$threadMessageEmitter == null ? other$threadMessageEmitter != null : !this$threadMessageEmitter.equals(other$threadMessageEmitter)) {
            return false;
        }
        Flowable<ThreadMessage> this$threadMessageFlowable = this.getThreadMessageFlowable();
        Flowable<ThreadMessage> other$threadMessageFlowable = other.getThreadMessageFlowable();
        if (this$threadMessageFlowable == null ? other$threadMessageFlowable != null : !this$threadMessageFlowable.equals(other$threadMessageFlowable)) {
            return false;
        }
        FlowableEmitter<RunStep> this$runStepEmitter = this.getRunStepEmitter();
        FlowableEmitter<RunStep> other$runStepEmitter = other.getRunStepEmitter();
        if (this$runStepEmitter == null ? other$runStepEmitter != null : !this$runStepEmitter.equals(other$runStepEmitter)) {
            return false;
        }
        Flowable<RunStep> this$runStepFlowable = this.getRunStepFlowable();
        Flowable<RunStep> other$runStepFlowable = other.getRunStepFlowable();
        return !(this$runStepFlowable == null ? other$runStepFlowable != null : !this$runStepFlowable.equals(other$runStepFlowable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultAssistantEventHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        AssistantThread $assistantThread = this.getAssistantThread();
        result = result * 59 + ($assistantThread == null ? 43 : ((Object)$assistantThread).hashCode());
        Run $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : ((Object)$run).hashCode());
        RunStep $finalRunStep = this.getFinalRunStep();
        result = result * 59 + ($finalRunStep == null ? 43 : ((Object)$finalRunStep).hashCode());
        ThreadMessage $finalMessage = this.getFinalMessage();
        result = result * 59 + ($finalMessage == null ? 43 : ((Object)$finalMessage).hashCode());
        LastError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        FlowableEmitter<ThreadMessage> $threadMessageEmitter = this.getThreadMessageEmitter();
        result = result * 59 + ($threadMessageEmitter == null ? 43 : $threadMessageEmitter.hashCode());
        Flowable<ThreadMessage> $threadMessageFlowable = this.getThreadMessageFlowable();
        result = result * 59 + ($threadMessageFlowable == null ? 43 : $threadMessageFlowable.hashCode());
        FlowableEmitter<RunStep> $runStepEmitter = this.getRunStepEmitter();
        result = result * 59 + ($runStepEmitter == null ? 43 : $runStepEmitter.hashCode());
        Flowable<RunStep> $runStepFlowable = this.getRunStepFlowable();
        result = result * 59 + ($runStepFlowable == null ? 43 : $runStepFlowable.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultAssistantEventHandler(assistantThread=" + this.getAssistantThread() + ", run=" + this.getRun() + ", finalRunStep=" + this.getFinalRunStep() + ", finalMessage=" + this.getFinalMessage() + ", error=" + this.getError() + ", isCompleted=" + this.isCompleted() + ", threadMessageEmitter=" + this.getThreadMessageEmitter() + ", threadMessageFlowable=" + this.getThreadMessageFlowable() + ", runStepEmitter=" + this.getRunStepEmitter() + ", runStepFlowable=" + this.getRunStepFlowable() + ")";
    }
}

