/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.servlet.util;

import com.alibaba.csp.sentinel.adapter.servlet.config.WebServletConfig;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FilterUtil {
    public static String filterTarget(HttpServletRequest request) {
        String pathInfo = FilterUtil.getResourcePath(request);
        if (!pathInfo.startsWith("/")) {
            pathInfo = "/" + pathInfo;
        }
        if ("/".equals(pathInfo)) {
            return pathInfo;
        }
        int lastSlashIndex = pathInfo.lastIndexOf("/");
        pathInfo = lastSlashIndex >= 0 ? pathInfo.substring(0, lastSlashIndex) + "/" + StringUtil.trim((String)pathInfo.substring(lastSlashIndex + 1)) : "/" + StringUtil.trim((String)pathInfo);
        return pathInfo;
    }

    public static void blockRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer url = request.getRequestURL();
        if ("GET".equals(request.getMethod()) && StringUtil.isNotBlank((String)request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        if (StringUtil.isEmpty((String)WebServletConfig.getBlockPage())) {
            FilterUtil.writeDefaultBlockedPage(response);
        } else {
            String redirectUrl = WebServletConfig.getBlockPage() + "?http_referer=" + url.toString();
            response.sendRedirect(redirectUrl);
        }
    }

    private static void writeDefaultBlockedPage(HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.println("Blocked by Sentinel (flow limiting)");
        out.flush();
        out.close();
    }

    private static String getResourcePath(HttpServletRequest request) {
        String pathInfo = FilterUtil.normalizeAbsolutePath(request.getPathInfo(), false);
        String servletPath = FilterUtil.normalizeAbsolutePath(request.getServletPath(), pathInfo.length() != 0);
        return servletPath + pathInfo;
    }

    private static String normalizeAbsolutePath(String path, boolean removeTrailingSlash) throws IllegalStateException {
        return FilterUtil.normalizePath(path, true, false, removeTrailingSlash);
    }

    private static String normalizePath(String path, boolean forceAbsolute, boolean forceRelative, boolean removeTrailingSlash) throws IllegalStateException {
        char[] pathChars = StringUtil.trimToEmpty((String)path).toCharArray();
        int length = pathChars.length;
        boolean startsWithSlash = false;
        boolean endsWithSlash = false;
        if (length > 0) {
            char firstChar = pathChars[0];
            char lastChar = pathChars[length - 1];
            startsWithSlash = firstChar == '/' || firstChar == '\\';
            endsWithSlash = lastChar == '/' || lastChar == '\\';
        }
        StringBuilder buf = new StringBuilder(length);
        boolean isAbsolutePath = forceAbsolute || !forceRelative && startsWithSlash;
        int index = startsWithSlash ? 0 : -1;
        int level = 0;
        if (isAbsolutePath) {
            buf.append("/");
        }
        while (index < length && (index = FilterUtil.indexOfSlash(pathChars, index + 1, false)) != length) {
            int nextSlashIndex = FilterUtil.indexOfSlash(pathChars, index, true);
            String element = new String(pathChars, index, nextSlashIndex - index);
            index = nextSlashIndex;
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                if (level == 0) {
                    if (isAbsolutePath) {
                        throw new IllegalStateException(path);
                    }
                    buf.append("../");
                    continue;
                }
                buf.setLength(pathChars[--level]);
                continue;
            }
            pathChars[level++] = (char)buf.length();
            buf.append(element).append('/');
        }
        if (buf.length() > 0 && (!endsWithSlash || removeTrailingSlash)) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int indexOfSlash(char[] chars, int beginIndex, boolean slash) {
        int i;
        for (i = beginIndex; i < chars.length; ++i) {
            char ch = chars[i];
            if (slash ? ch == '/' || ch == '\\' : ch != '/' && ch != '\\') break;
        }
        return i;
    }

    private FilterUtil() {
    }
}

