/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hyperic.sigar.win32.EventLog;
import org.hyperic.sigar.win32.EventLogNotification;
import org.hyperic.sigar.win32.EventLogRecord;
import org.hyperic.sigar.win32.Win32Exception;

public class EventLogThread
implements Runnable {
    public static final int DEFAULT_INTERVAL = 60000;
    private static Logger logger = Logger.getLogger(EventLogThread.class.getName());
    private Thread thread = null;
    private static HashMap logs = new HashMap();
    private boolean shouldDie = false;
    private Set notifiers = Collections.synchronizedSet(new HashSet());
    private String logName = "Application";
    private long interval = 60000L;

    public static EventLogThread getInstance() {
        return EventLogThread.getInstance("Application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventLogThread getInstance(String name) {
        EventLogThread instance;
        HashMap hashMap = logs;
        synchronized (hashMap) {
            instance = (EventLogThread)logs.get(name);
            if (instance == null) {
                instance = new EventLogThread();
                instance.setLogName(name);
                logs.put(name, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeInstances() {
        HashMap hashMap = logs;
        synchronized (hashMap) {
            Iterator it = logs.values().iterator();
            while (it.hasNext()) {
                EventLogThread eventLogThread = (EventLogThread)it.next();
                eventLogThread.doStop();
            }
            logs.clear();
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "EventLogThread");
        this.thread.setDaemon(true);
        this.thread.start();
        logger.debug(this.thread.getName() + " started");
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        this.die();
        this.thread.interrupt();
        logger.debug(this.thread.getName() + " stopped");
        this.thread = null;
    }

    public void add(EventLogNotification notifier) {
        this.notifiers.add(notifier);
    }

    public void remove(EventLogNotification notifier) {
        this.notifiers.remove(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvents(EventLog log, int curEvent, int lastEvent) {
        for (int i = curEvent + 1; i <= lastEvent; ++i) {
            EventLogRecord record;
            try {
                record = log.read(i);
            }
            catch (Win32Exception e) {
                logger.error("Unable to read event id " + i + ": " + e);
                continue;
            }
            Set set = this.notifiers;
            synchronized (set) {
                Iterator it = this.notifiers.iterator();
                while (it.hasNext()) {
                    EventLogNotification notification = (EventLogNotification)it.next();
                    if (!notification.matches(record)) continue;
                    notification.handleNotification(record);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EventLog log = new EventLog();
        try {
            log.open(this.logName);
            int curEvent = log.getNewestRecord();
            while (!this.shouldDie) {
                int lastEvent = log.getNewestRecord();
                if (lastEvent > curEvent) {
                    this.handleEvents(log, curEvent, lastEvent);
                }
                curEvent = lastEvent;
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (Win32Exception e) {
            logger.error("Unable to monitor event log: ", e);
        }
        finally {
            try {
                log.close();
            }
            catch (Win32Exception win32Exception) {}
        }
    }

    public void die() {
        this.shouldDie = true;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"System", "Application", "Security"};
        }
        EventLogNotification watcher = new EventLogNotification(){

            public boolean matches(EventLogRecord record) {
                return true;
            }

            public void handleNotification(EventLogRecord record) {
                System.out.println(record);
            }
        };
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            EventLogThread eventLogThread = EventLogThread.getInstance(name);
            eventLogThread.doStart();
            eventLogThread.setInterval(1000L);
            eventLogThread.add(watcher);
        }
        System.out.println("Press any key to stop");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EventLogThread.closeInstances();
    }
}

