/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.ArrayList;
import org.hyperic.sigar.NetRoute;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Route
extends SigarCommandBase {
    private static final String OUTPUT_FORMAT = "%-15s %-15s %-15s %-5s %-6s %-3s %-s";
    private static final String[] HEADER = new String[]{"Destination", "Gateway", "Genmask", "Flags", "Metric", "Ref", "Iface"};

    public Route(Shell shell) {
        super(shell);
        this.setOutputFormat(OUTPUT_FORMAT);
    }

    public Route() {
        this.setOutputFormat(OUTPUT_FORMAT);
    }

    private static String flags(long flags) {
        StringBuffer sb = new StringBuffer();
        if ((flags & 1L) != 0L) {
            sb.append('U');
        }
        if ((flags & 2L) != 0L) {
            sb.append('G');
        }
        return sb.toString();
    }

    public String getUsageShort() {
        return "Kernel IP routing table";
    }

    public void output(String[] args) throws SigarException {
        NetRoute[] routes = this.sigar.getNetRouteList();
        this.printf(HEADER);
        for (int i = 0; i < routes.length; ++i) {
            NetRoute route = routes[i];
            ArrayList<String> items = new ArrayList<String>();
            items.add(route.getDestination());
            items.add(route.getGateway());
            items.add(route.getMask());
            items.add(Route.flags(route.getFlags()));
            items.add(String.valueOf(route.getMetric()));
            items.add(String.valueOf(route.getRefcnt()));
            items.add(route.getIfname());
            this.printf(items);
        }
    }

    public static void main(String[] args) throws Exception {
        new Route().processCommand(args);
    }
}

