/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.util;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.navercorp.pinpoint.common.arms.logger.ArmsLogger;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.thrift.io.DeserializerFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.SerializerFactory;

public final class SerializationUtils {
    private final PLogger logger = PLoggerFactory.getLogger(SerializationUtils.class);

    private SerializationUtils() {
    }

    public static byte[] serialize(TBase object, SerializerFactory<HeaderTBaseSerializer> factory) throws TException {
        SerializationUtils.assertNotNull(factory, "SerializerFactory may note be null.");
        return SerializationUtils.serialize(object, factory.createSerializer());
    }

    public static byte[] serialize(TBase object, HeaderTBaseSerializer serializer) throws TException {
        SerializationUtils.assertNotNull(object, "TBase may note be null.");
        SerializationUtils.assertNotNull(serializer, "Serializer may note be null.");
        return serializer.serialize(object);
    }

    public static byte[] serialize(TBase object, SerializerFactory<HeaderTBaseSerializer> factory, byte[] defaultValue) {
        try {
            return SerializationUtils.serialize(object, factory);
        }
        catch (Exception e) {
            if (ArmsLogger.isWarnEnabled()) {
                ArmsLogger.warn("Serialize " + object + " failed. Error:" + e.getMessage(), e);
            }
            return defaultValue;
        }
    }

    public static byte[] serialize(TBase object, HeaderTBaseSerializer serializer, byte[] defaultValue) {
        try {
            return SerializationUtils.serialize(object, serializer);
        }
        catch (Exception e) {
            if (ArmsLogger.isWarnEnabled()) {
                ArmsLogger.warn("Serialize " + object + " failed. Error:" + e.getMessage(), e);
            }
            return defaultValue;
        }
    }

    public static TBase deserialize(byte[] objectData, DeserializerFactory<HeaderTBaseDeserializer> factory) throws TException {
        SerializationUtils.assertNotNull(factory, "DeserializerFactory may note be null.");
        return SerializationUtils.deserialize(objectData, factory.createDeserializer());
    }

    public static TBase deserialize(byte[] objectData, HeaderTBaseDeserializer deserializer) throws TException {
        SerializationUtils.assertNotNull(objectData, "TBase may note be null.");
        SerializationUtils.assertNotNull(deserializer, "Deserializer may note be null.");
        return deserializer.deserialize(objectData);
    }

    public static TBase deserialize(byte[] objectData, DeserializerFactory<HeaderTBaseDeserializer> factory, TBase defaultValue) {
        try {
            return SerializationUtils.deserialize(objectData, factory);
        }
        catch (Exception e) {
            if (ArmsLogger.isWarnEnabled()) {
                ArmsLogger.warn("Deserialize failed. Error:" + e.getMessage(), e);
            }
            return defaultValue;
        }
    }

    public static TBase deserialize(byte[] objectData, HeaderTBaseDeserializer deserializer, TBase defaultValue) {
        try {
            return SerializationUtils.deserialize(objectData, deserializer);
        }
        catch (Exception e) {
            if (ArmsLogger.isWarnEnabled()) {
                ArmsLogger.warn("Deserialize failed. Error:" + e.getMessage(), e);
            }
            return defaultValue;
        }
    }

    private static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }
}

