/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadCount;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadCountRes;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TCommandEcho;
import com.navercorp.pinpoint.thrift.dto.command.TCommandThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCommandThreadDumpResponse;
import com.navercorp.pinpoint.thrift.dto.command.TCommandTransfer;
import com.navercorp.pinpoint.thrift.dto.command.TCommandTransferResponse;
import com.navercorp.pinpoint.thrift.io.Header;
import java.util.EnumSet;
import java.util.Set;

public enum TCommandType {
    RESULT(320, TResult.class){

        @Override
        public TBase newObject() {
            return new TResult();
        }
    }
    ,
    TRANSFER(700, TCommandTransfer.class){

        @Override
        public TBase newObject() {
            return new TCommandTransfer();
        }
    }
    ,
    TRANSFER_RESPONSE(701, TCommandTransferResponse.class){

        @Override
        public TBase newObject() {
            return new TCommandTransferResponse();
        }
    }
    ,
    ECHO(710, TCommandEcho.class){

        @Override
        public TBase newObject() {
            return new TCommandEcho();
        }
    }
    ,
    THREAD_DUMP(720, TCommandThreadDump.class){

        @Override
        public TBase newObject() {
            return new TCommandThreadDump();
        }
    }
    ,
    THREAD_DUMP_RESPONSE(721, TCommandThreadDumpResponse.class){

        @Override
        public TBase newObject() {
            return new TCommandThreadDumpResponse();
        }
    }
    ,
    ACTIVE_THREAD_COUNT(730, TCmdActiveThreadCount.class){

        @Override
        public TBase newObject() {
            return new TCmdActiveThreadCount();
        }
    }
    ,
    ACTIVE_THREAD_COUNT_RESPONSE(731, TCmdActiveThreadCountRes.class){

        @Override
        public TBase newObject() {
            return new TCmdActiveThreadCountRes();
        }
    }
    ,
    ACTIVE_THREAD_DUMP(740, TCmdActiveThreadDump.class){

        @Override
        public TBase newObject() {
            return new TCmdActiveThreadDump();
        }
    }
    ,
    ACTIVE_THREAD_DUMP_RESPONSE(741, TCmdActiveThreadDumpRes.class){

        @Override
        public TBase newObject() {
            return new TCmdActiveThreadDumpRes();
        }
    }
    ,
    ACTIVE_THREAD_LIGHT_DUMP(750, TCmdActiveThreadLightDump.class){

        @Override
        public TBase newObject() {
            return new TCmdActiveThreadLightDump();
        }
    }
    ,
    ACTIVE_THREAD_LIGHT_DUMP_RESPONSE(751, TCmdActiveThreadLightDumpRes.class){

        @Override
        public TBase newObject() {
            return new TCmdActiveThreadLightDumpRes();
        }
    };

    private final short code;
    private final Class<? extends TBase> clazz;
    private final Header header;
    private static final Set<TCommandType> TCOMMAND_TYPES;

    private TCommandType(short code, Class<? extends TBase> clazz) {
        this.code = code;
        this.clazz = clazz;
        this.header = TCommandType.createHeader(code);
    }

    public short getCode() {
        return this.code;
    }

    public Class getClazz() {
        return this.clazz;
    }

    protected boolean isInstanceOf(Object value) {
        return this.clazz.isInstance(value);
    }

    protected Header getHeader() {
        return this.header;
    }

    public abstract TBase newObject();

    private static Header createHeader(short code) {
        Header header = new Header();
        header.setType(code);
        return header;
    }

    public static TCommandType getType(Class<? extends TBase> clazz) {
        for (TCommandType commandType : TCOMMAND_TYPES) {
            if (commandType.getClazz() != clazz) continue;
            return commandType;
        }
        return null;
    }

    public static TCommandType getType(short code) {
        for (TCommandType commandType : TCOMMAND_TYPES) {
            if (commandType.getCode() != code) continue;
            return commandType;
        }
        return null;
    }

    static {
        TCOMMAND_TYPES = EnumSet.allOf(TCommandType.class);
    }
}

