/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.thrift.io.BufferOverflowException;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PinpointByteArrayOutputStream
extends ResettableByteArrayOutputStream {
    private final boolean autoExpand;

    public PinpointByteArrayOutputStream() {
        this(32);
    }

    public PinpointByteArrayOutputStream(int size) {
        this(size, true);
    }

    public PinpointByteArrayOutputStream(int size, boolean autoExpand) {
        super(size);
        this.autoExpand = autoExpand;
    }

    @Override
    public synchronized void write(int b) {
        if (this.autoExpand) {
            super.write(b);
        } else {
            boolean isOverflow = this.isOverflow(this.count + 1);
            if (isOverflow) {
                throw new BufferOverflowException("Buffer size cannot exceed " + this.buf.length + ". (now:" + this.count + ", input-size:1");
            }
            this.buf[this.count] = (byte)b;
            ++this.count;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (this.autoExpand) {
            super.write(b, off, len);
        } else {
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            boolean isOverflow = this.isOverflow(this.count + len);
            if (isOverflow) {
                throw new BufferOverflowException("Buffer size cannot exceed " + this.buf.length + ". (now:" + this.count + ", input-size:" + len);
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }
    }

    @Override
    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    private boolean isOverflow(int minCapacity) {
        return minCapacity - this.buf.length > 0;
    }
}

