/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocol;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocolFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.transport.TIOStreamTransport;
import com.navercorp.pinpoint.thrift.io.BytesUtils;
import com.navercorp.pinpoint.thrift.io.Header;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.TBaseLocator;
import java.io.UnsupportedEncodingException;

public class HeaderTBaseSerializer {
    private static final String UTF8 = "UTF8";
    private final ResettableByteArrayOutputStream baos;
    private final TProtocol protocol;
    private final TBaseLocator locator;

    HeaderTBaseSerializer(ResettableByteArrayOutputStream bos, TProtocolFactory protocolFactory, TBaseLocator locator) {
        this.baos = bos;
        TIOStreamTransport transport = new TIOStreamTransport(bos);
        this.protocol = protocolFactory.getProtocol(transport);
        this.locator = locator;
    }

    public byte[] serialize(TBase<?, ?> base) throws TException {
        Header header = this.locator.headerLookup(base);
        this.baos.reset();
        this.writeHeader(header);
        base.write(this.protocol);
        return this.baos.toByteArray();
    }

    public byte[] continueSerialize(TBase<?, ?> base) throws TException {
        Header header = this.locator.headerLookup(base);
        this.writeHeader(header);
        base.write(this.protocol);
        return this.baos.toByteArray();
    }

    public void reset() {
        this.baos.reset();
    }

    public void reset(int resetIndex) {
        this.baos.reset(resetIndex);
    }

    public int getInterBufferSize() {
        return this.baos.size();
    }

    private void writeHeader(Header header) throws TException {
        this.protocol.writeByte(header.getSignature());
        this.protocol.writeByte(header.getVersion());
        short type = header.getType();
        this.protocol.writeByte(BytesUtils.writeShort1(type));
        this.protocol.writeByte(BytesUtils.writeShort2(type));
    }

    public String toString(TBase<?, ?> base) throws TException {
        return this.toString(base, UTF8);
    }

    public String toString(TBase<?, ?> base, String charset) throws TException {
        try {
            return new String(this.serialize(base), charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }
}

