/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocol;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocolFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.transport.TMemoryInputTransport;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.thrift.io.Header;
import com.navercorp.pinpoint.thrift.io.HeaderUtils;
import com.navercorp.pinpoint.thrift.io.TBaseLocator;
import java.util.ArrayList;
import java.util.List;

public class HeaderTBaseDeserializer {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TProtocol protocol;
    private final TMemoryInputTransport trans = new TMemoryInputTransport();
    private final TBaseLocator locator;

    HeaderTBaseDeserializer(TProtocolFactory protocolFactory, TBaseLocator locator) {
        this.protocol = protocolFactory.getProtocol(this.trans);
        this.locator = locator;
    }

    public TBase<?, ?> deserialize(byte[] bytes) throws TException {
        try {
            this.trans.reset(bytes);
            Header header = this.readHeader();
            int validate = this.validate(header);
            if (validate == -17) {
                TBase<?, ?> base = this.locator.tBaseLookup(header.getType());
                base.read(this.protocol);
                TBase<?, ?> tBase = base;
                return tBase;
            }
            throw new IllegalStateException("invalid validate " + validate);
        }
        finally {
            this.trans.clear();
            this.protocol.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TBase<?, ?>> deserializeList(byte[] buffer) throws TException {
        ArrayList tBaseList = new ArrayList();
        this.trans.reset(buffer);
        try {
            while (this.trans.getBytesRemainingInBuffer() > 0) {
                Header header = this.readHeader();
                int validate = this.validate(header);
                if (validate == -17) {
                    TBase<?, ?> base = this.locator.tBaseLookup(header.getType());
                    base.read(this.protocol);
                    tBaseList.add(base);
                    continue;
                }
                throw new IllegalStateException("invalid validate " + validate);
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to deserialize.", e);
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            this.trans.clear();
            this.protocol.reset();
        }
        return tBaseList;
    }

    private int validate(Header header) throws TException {
        byte signature = header.getSignature();
        int result = HeaderUtils.validateSignature(signature);
        if (result == 0) {
            throw new TException("Invalid Signature:" + header);
        }
        return result;
    }

    private Header readHeader() throws TException {
        byte signature = this.protocol.readByte();
        byte version = this.protocol.readByte();
        byte type1 = this.protocol.readByte();
        byte type2 = this.protocol.readByte();
        short type = this.bytesToShort(type1, type2);
        return new Header(signature, version, type);
    }

    private short bytesToShort(byte byte1, byte byte2) {
        return (short)((byte1 & 0xFF) << 8 | byte2 & 0xFF);
    }
}

