/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.thrift.dto.flink.TFAgentStatBatch;
import com.navercorp.pinpoint.thrift.io.Header;
import com.navercorp.pinpoint.thrift.io.TBaseLocator;

public class FlinkTBaseLocator
implements TBaseLocator {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final short AGENT_STAT_BATCH = 1000;
    private static final Header AGENT_STAT_BATCH_HEADER = FlinkTBaseLocator.createHeader((short)1000);

    @Override
    public TBase<?, ?> tBaseLookup(short type) throws TException {
        switch (type) {
            case 1000: {
                return new TFAgentStatBatch();
            }
        }
        throw new TException("Unsupported type:" + type);
    }

    @Override
    public Header headerLookup(TBase<?, ?> tbase) throws TException {
        if (tbase instanceof TFAgentStatBatch) {
            return AGENT_STAT_BATCH_HEADER;
        }
        throw new TException("Unsupported Type" + tbase.getClass());
    }

    @Override
    public boolean isSupport(short type) {
        try {
            this.tBaseLookup(type);
            return true;
        }
        catch (TException ignore) {
            this.logger.warn("{} is not support type", (Object)type);
            return false;
        }
    }

    @Override
    public boolean isSupport(Class<? extends TBase> clazz) {
        return clazz.equals(TFAgentStatBatch.class);
    }

    private static Header createHeader(short type) {
        Header header = new Header();
        header.setType(type);
        return header;
    }

    @Override
    public Header getChunkHeader() {
        return null;
    }

    @Override
    public boolean isChunkHeader(short type) {
        return false;
    }
}

