/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocol;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocolFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.transport.TMemoryInputTransport;
import com.navercorp.pinpoint.thrift.io.Header;
import com.navercorp.pinpoint.thrift.io.HeaderUtils;
import com.navercorp.pinpoint.thrift.io.TBaseLocator;
import java.util.ArrayList;
import java.util.List;

public class ChunkHeaderTBaseDeserializer {
    private final TProtocol protocol;
    private final TMemoryInputTransport trans = new TMemoryInputTransport();
    private final TBaseLocator locator;

    ChunkHeaderTBaseDeserializer(TProtocolFactory protocolFactory, TBaseLocator locator) {
        this.protocol = protocolFactory.getProtocol(this.trans);
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TBase<?, ?>> deserialize(byte[] bytes, int offset, int length) throws TException {
        ArrayList list = new ArrayList();
        try {
            this.trans.reset(bytes, offset, length);
            Header header = this.readHeader();
            if (header == null) {
                ArrayList arrayList = list;
                return arrayList;
            }
            if (this.locator.isChunkHeader(header.getType())) {
                TBase<?, ?> base;
                while ((base = this.deserialize()) != null) {
                    list.add(base);
                }
            } else {
                TBase<?, ?> base = this.deserialize();
                if (base != null) {
                    list.add(base);
                }
            }
        }
        finally {
            this.trans.clear();
            this.protocol.reset();
        }
        return list;
    }

    private TBase<?, ?> deserialize() throws TException {
        Header header = this.readHeader();
        if (header == null) {
            return null;
        }
        int validate = this.validate(header);
        TBase<?, ?> base = this.locator.tBaseLookup(header.getType());
        base.read(this.protocol);
        return base;
    }

    private int validate(Header header) throws TException {
        byte signature = header.getSignature();
        int result = HeaderUtils.validateSignature(signature);
        if (result == 0) {
            throw new TException("Invalid Signature:" + header);
        }
        return result;
    }

    private Header readHeader() throws TException {
        if (this.trans.getBytesRemainingInBuffer() < 4) {
            return null;
        }
        byte signature = this.protocol.readByte();
        byte version = this.protocol.readByte();
        byte type1 = this.protocol.readByte();
        byte type2 = this.protocol.readByte();
        short type = this.bytesToShort(type1, type2);
        return new Header(signature, version, type);
    }

    private short bytesToShort(byte byte1, byte byte2) {
        return (short)((byte1 & 0xFF) << 8 | byte2 & 0xFF);
    }
}

