/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.util;

import com.navercorp.pinpoint.common.arms.logger.ArmsLogger;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ClientFactoryUtils {
    public static PinpointClient createPinpointClient(InetSocketAddress connectAddress, PinpointClientFactory clientFactory) {
        PinpointClient pinpointClient = null;
        for (int i = 0; i < 3; ++i) {
            try {
                pinpointClient = clientFactory.connect(connectAddress);
                ArmsLogger.warn("tcp connect success. remote:{}", (Object)connectAddress);
                return pinpointClient;
            }
            catch (PinpointSocketException e) {
                ArmsLogger.warn("tcp connect fail. remote:{} try reconnect, retryCount:{}", (Object)connectAddress, (Object)i);
                continue;
            }
        }
        ArmsLogger.warn("change background tcp connect mode remote:{} ", (Object)connectAddress);
        pinpointClient = clientFactory.scheduledConnect(connectAddress);
        return pinpointClient;
    }

    public static PinpointClient createPinpointClient(String host, int port, PinpointClientFactory clientFactory) {
        int i;
        PinpointClient pinpointClient = null;
        Pattern pattern = Pattern.compile("arms-[a-z]+-[a-z]+\\.aliyuncs\\.com");
        Matcher matcher = pattern.matcher(host);
        InetSocketAddress internalAddress = null;
        if (matcher.matches()) {
            String internalHost = host.replaceAll("\\.aliyuncs\\.com", "-internal\\.aliyuncs\\.com");
            internalAddress = new InetSocketAddress(internalHost, port);
            for (i = 0; i < 1; ++i) {
                try {
                    clientFactory.setConnectTimeout(1000);
                    pinpointClient = clientFactory.connect(internalAddress);
                    ArmsLogger.warn("tcp connect success. remote:{}", (Object)internalAddress);
                    return pinpointClient;
                }
                catch (PinpointSocketException e) {
                    ArmsLogger.warn("tcp connect fail. remote:{} try reconnect, retryCount:{}", (Object)internalAddress, (Object)i);
                    continue;
                }
            }
        }
        InetSocketAddress publicAddress = new InetSocketAddress(host, port);
        for (i = 0; i < 1; ++i) {
            try {
                clientFactory.setConnectTimeout(1000);
                pinpointClient = clientFactory.connect(publicAddress);
                ArmsLogger.warn("tcp connect success. remote:{}", (Object)publicAddress);
                return pinpointClient;
            }
            catch (PinpointSocketException e) {
                ArmsLogger.warn("tcp connect fail. remote:{} try reconnect, retryCount:{}", (Object)publicAddress, (Object)i);
                continue;
            }
        }
        ArmsLogger.warn("change background tcp connect mode remote:{} ", (Object)publicAddress);
        clientFactory.setInternalAddress(internalAddress);
        clientFactory.setPublicAddress(publicAddress);
        pinpointClient = clientFactory.scheduledConnect(publicAddress);
        return pinpointClient;
    }
}

