/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.stream.StreamChannelStateCode;
import java.util.concurrent.atomic.AtomicReference;

public class StreamChannelState {
    private final AtomicReference<StreamChannelStateCode> currentStateReference = new AtomicReference();

    public StreamChannelState() {
        this.currentStateReference.set(StreamChannelStateCode.NEW);
    }

    public StreamChannelStateCode getCurrentState() {
        return this.currentStateReference.get();
    }

    boolean to(StreamChannelStateCode nextState) {
        return this.to(this.currentStateReference.get(), nextState);
    }

    boolean to(StreamChannelStateCode currentState, StreamChannelStateCode nextState) {
        if (!nextState.canChangeState(currentState)) {
            return false;
        }
        boolean isChanged = this.currentStateReference.compareAndSet(currentState, nextState);
        return isChanged;
    }

    public String toString() {
        return this.currentStateReference.get().name();
    }
}

