/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.group.ChannelGroup;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timeout;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.TimerTask;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.client.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.packet.PingPacket;
import com.navercorp.pinpoint.rpc.packet.PingSimplePacket;
import com.navercorp.pinpoint.rpc.server.HealthCheckState;
import com.navercorp.pinpoint.rpc.server.PinpointServer;
import java.util.concurrent.TimeUnit;

public class HealthCheckManager {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private static final PingSimplePacket PING_PACKET = PingSimplePacket.PING_PACKET;
    private static final PingPacket LEGACY_PING_PACKET = PingPacket.PING_PACKET;
    private static final long MAXIMUM_WAITING_TIME_MILLIS = 1800000L;
    private volatile boolean startMethodInvoked = false;
    private volatile boolean isStopped = false;
    private final Timer timer;
    private final long waitTimeMillis;
    private final ChannelGroup channelGroup;
    private final WriteFailFutureListener writeFailListener = new WriteFailFutureListener(this.logger, "ping write fail.", "ping write success.");

    public HealthCheckManager(Timer healthCheckTimer, ChannelGroup channelGroup) {
        this(healthCheckTimer, 1800000L, channelGroup);
    }

    public HealthCheckManager(Timer timer, long waitTimeMillis, ChannelGroup channelGroup) {
        Assert.requireNonNull(timer, "timer must not be null");
        Assert.isTrue(waitTimeMillis > 0L, "waitTimeMillis is must greater than 0");
        Assert.requireNonNull(channelGroup, "channelGroup must not be null");
        this.timer = timer;
        this.waitTimeMillis = waitTimeMillis;
        this.channelGroup = channelGroup;
    }

    public void start(long intervalMillis) {
        Assert.isTrue(intervalMillis > 0L, "intervalMillis is must be greater than zero");
        this.logger.debug("start() started");
        if (this.isStopped) {
            this.logger.warn("start() failed. already stopped");
            return;
        }
        if (this.startMethodInvoked) {
            this.logger.warn("start() failed. already invoked");
            return;
        }
        this.startMethodInvoked = true;
        this.registerTask(new HealthCheckTask(intervalMillis));
    }

    public void stop() {
        this.logger.debug("stop() started");
        if (!this.isStopped) {
            this.isStopped = true;
        }
    }

    private void registerTask(HealthCheckTask task) {
        try {
            this.logger.debug("registerTask() started");
            this.timer.newTimeout(task, task.getIntervalMillis(), TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException e) {
            this.logger.debug("timer stopped. Caused:{}", (Object)e.getMessage());
        }
    }

    private PinpointServer getPinpointServer(Channel channel) {
        if (channel == null) {
            return null;
        }
        if (!channel.isConnected()) {
            return null;
        }
        Object attachment = channel.getAttachment();
        if (attachment instanceof PinpointServer) {
            return (PinpointServer)attachment;
        }
        return null;
    }

    private boolean hasExpiredReceivingPing(PinpointServer pinpointServer) {
        if (pinpointServer.getHealthCheckState() != HealthCheckState.WAIT) {
            return false;
        }
        long waitStartTimestamp = pinpointServer.getStartTimestamp();
        return System.currentTimeMillis() > waitStartTimestamp + this.waitTimeMillis;
    }

    private class HealthCheckTask
    implements TimerTask {
        private final long intervalMillis;

        public HealthCheckTask(long intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (HealthCheckManager.this.isStopped) {
                return;
            }
            if (timeout.isCancelled()) {
                HealthCheckManager.this.registerTask(this);
                return;
            }
            for (Channel channel : HealthCheckManager.this.channelGroup) {
                PinpointServer pinpointServer = HealthCheckManager.this.getPinpointServer(channel);
                if (pinpointServer == null) continue;
                HealthCheckState healthCheckState = pinpointServer.getHealthCheckState();
                switch (healthCheckState) {
                    case RECEIVED: {
                        if (HealthCheckManager.this.isDebug) {
                            HealthCheckManager.this.logger.debug("ping write. channel:{}, packet:{}.", (Object)channel, (Object)PING_PACKET);
                        }
                        if (channel.isWritable()) {
                            channel.write(PING_PACKET).addListener(HealthCheckManager.this.writeFailListener);
                            break;
                        }
                        HealthCheckManager.this.logger.error("[HealthCheckManager] RECEIVED channel isWritable is false! channel: " + channel);
                        break;
                    }
                    case RECEIVED_LEGACY: {
                        if (HealthCheckManager.this.isDebug) {
                            HealthCheckManager.this.logger.debug("ping write. channel:{}, packet:{}.", (Object)channel, (Object)LEGACY_PING_PACKET);
                        }
                        if (channel.isWritable()) {
                            channel.write(LEGACY_PING_PACKET).addListener(HealthCheckManager.this.writeFailListener);
                            break;
                        }
                        HealthCheckManager.this.logger.error("[HealthCheckManager] RECEIVED_LEGACY channel isWritable is false! channel: " + channel);
                        break;
                    }
                    case WAIT: {
                        if (!HealthCheckManager.this.hasExpiredReceivingPing(pinpointServer)) break;
                        HealthCheckManager.this.logger.warn("expired while waiting to receive ping. channel:{} will be closed", (Object)channel);
                        channel.close();
                    }
                }
            }
            if (!HealthCheckManager.this.isStopped) {
                HealthCheckManager.this.registerTask(this);
            }
        }

        private long getIntervalMillis() {
            return this.intervalMillis;
        }
    }
}

