/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.navercorp.pinpoint.rpc.packet.stream.BasicStreamPacket;

public class StreamPongPacket
extends BasicStreamPacket {
    private static final short PACKET_TYPE = 18;
    private final int requestId;

    public StreamPongPacket(int streamChannelId, int requestId) {
        super(streamChannelId);
        this.requestId = requestId;
    }

    @Override
    public short getPacketType() {
        return 18;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer(10);
        header.writeShort(this.getPacketType());
        header.writeInt(this.getStreamChannelId());
        header.writeInt(this.requestId);
        return header;
    }

    public static StreamPongPacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 18);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int streamChannelId = buffer.readInt();
        int requestId = buffer.readInt();
        StreamPongPacket packet = new StreamPongPacket(streamChannelId, requestId);
        return packet;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{channelId=").append(this.getStreamChannelId());
        sb.append(", ");
        sb.append("requestId=").append(this.getRequestId());
        sb.append('}');
        return sb.toString();
    }
}

