/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import com.navercorp.pinpoint.rpc.packet.stream.BasicStreamPacket;

public class StreamCreatePacket
extends BasicStreamPacket {
    private static final short PACKET_TYPE = 10;
    private final byte[] payload;

    public StreamCreatePacket(int streamChannelId, byte[] payload) {
        super(streamChannelId);
        Assert.requireNonNull(payload, "payload must not be null");
        this.payload = payload;
    }

    @Override
    public short getPacketType() {
        return 10;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer(10);
        header.writeShort(this.getPacketType());
        header.writeInt(this.getStreamChannelId());
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static StreamCreatePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 10);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int streamChannelId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        StreamCreatePacket packet = new StreamCreatePacket(streamChannelId, payload.array());
        return packet;
    }
}

