/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.navercorp.pinpoint.rpc.packet.stream.BasicStreamPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;

public class StreamClosePacket
extends BasicStreamPacket {
    private static final short PACKET_TYPE = 15;
    private final StreamCode code;

    public StreamClosePacket(int streamChannelId, short code) {
        this(streamChannelId, StreamCode.getCode(code));
    }

    public StreamClosePacket(int streamChannelId, StreamCode code) {
        super(streamChannelId);
        this.code = code;
    }

    @Override
    public short getPacketType() {
        return 15;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer(8);
        header.writeShort(this.getPacketType());
        header.writeInt(this.getStreamChannelId());
        header.writeShort(this.code.value());
        return header;
    }

    public static StreamClosePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 15);
        if (buffer.readableBytes() < 6) {
            buffer.resetReaderIndex();
            return null;
        }
        int streamChannelId = buffer.readInt();
        short code = buffer.readShort();
        StreamClosePacket packet = new StreamClosePacket(streamChannelId, code);
        return packet;
    }

    public StreamCode getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{streamChannelId=").append(this.getStreamChannelId());
        sb.append(", ");
        sb.append("code=").append((Object)this.getCode());
        sb.append('}');
        return sb.toString();
    }
}

