/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.navercorp.pinpoint.rpc.packet.Packet;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;

public class TraceSendPacket
extends SendPacket {
    private int traceId;

    public TraceSendPacket() {
    }

    public TraceSendPacket(byte[] payload) {
        super(payload);
    }

    public TraceSendPacket(int traceId, byte[] payload) {
        super(payload);
        this.traceId = traceId;
    }

    public int getTraceId() {
        return this.traceId;
    }

    public void setTraceId(int traceId) {
        this.traceId = traceId;
    }

    @Override
    public short getPacketType() {
        return 2;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer(10);
        header.writeShort(2);
        header.writeInt(this.traceId);
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static Packet readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 2);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int traceId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        return new TraceSendPacket(traceId, payload.array());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("TraceSendPacket");
        sb.append("{traceId=").append(this.traceId);
        sb.append(", ");
        if (this.payload == null) {
            sb.append("payload=null}");
        } else {
            sb.append("payloadLength=").append(this.payload.length);
            sb.append('}');
        }
        return sb.toString();
    }
}

