/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.navercorp.pinpoint.rpc.packet.ControlPacket;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;

public class ControlHandshakeResponsePacket
extends ControlPacket {
    public static final String CODE = "code";
    public static final String SUB_CODE = "subCode";
    public static final String CLUSTER = "cluster";

    public ControlHandshakeResponsePacket(byte[] payload) {
        super(payload);
    }

    public ControlHandshakeResponsePacket(int requestId, byte[] payload) {
        super(payload);
        this.setRequestId(requestId);
    }

    @Override
    public short getPacketType() {
        return 151;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer(10);
        header.writeShort(151);
        header.writeInt(this.getRequestId());
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static ControlHandshakeResponsePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 151);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int messageId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        ControlHandshakeResponsePacket helloPacket = new ControlHandshakeResponsePacket(payload.array());
        helloPacket.setRequestId(messageId);
        return helloPacket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{requestId=").append(this.getRequestId());
        sb.append(", ");
        if (this.payload == null) {
            sb.append("payload=null");
        } else {
            sb.append("payloadLength=").append(this.payload.length);
        }
        sb.append('}');
        return sb.toString();
    }
}

