/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.navercorp.pinpoint.rpc.packet.ControlPacket;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;

public class ControlHandshakePacket
extends ControlPacket {
    public ControlHandshakePacket(byte[] payload) {
        super(payload);
    }

    public ControlHandshakePacket(int requestId, byte[] payload) {
        super(payload);
        this.setRequestId(requestId);
    }

    @Override
    public short getPacketType() {
        return 150;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer(10);
        header.writeShort(150);
        header.writeInt(this.getRequestId());
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static ControlHandshakePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 150);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int messageId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        ControlHandshakePacket helloPacket = new ControlHandshakePacket(payload.array());
        helloPacket.setRequestId(messageId);
        return helloPacket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{requestId=").append(this.getRequestId());
        sb.append(", ");
        if (this.payload == null) {
            sb.append("payload=null");
        } else {
            sb.append("payloadLength=").append(this.payload.length);
        }
        sb.append('}');
        return sb.toString();
    }
}

