/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.common;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum SocketStateCode {
    NONE(1, new SocketStateCode[0]),
    BEING_CONNECT(2, NONE),
    CONNECTED(3, NONE, BEING_CONNECT),
    CONNECT_FAILED(6, BEING_CONNECT),
    IGNORE(9, CONNECTED),
    RUN_WITHOUT_HANDSHAKE(10, CONNECTED),
    RUN_SIMPLEX(11, RUN_WITHOUT_HANDSHAKE),
    RUN_DUPLEX(12, RUN_WITHOUT_HANDSHAKE),
    BEING_CLOSE_BY_CLIENT(20, RUN_WITHOUT_HANDSHAKE, RUN_SIMPLEX, RUN_DUPLEX),
    CLOSED_BY_CLIENT(22, NONE, BEING_CLOSE_BY_CLIENT),
    UNEXPECTED_CLOSE_BY_CLIENT(26, NONE, CONNECTED, RUN_WITHOUT_HANDSHAKE, RUN_SIMPLEX, RUN_DUPLEX),
    BEING_CLOSE_BY_SERVER(30, RUN_WITHOUT_HANDSHAKE, RUN_SIMPLEX, RUN_DUPLEX),
    CLOSED_BY_SERVER(32, NONE, BEING_CLOSE_BY_SERVER),
    UNEXPECTED_CLOSE_BY_SERVER(36, NONE, CONNECTED, RUN_WITHOUT_HANDSHAKE, RUN_SIMPLEX, RUN_DUPLEX),
    ERROR_UNKNOWN(40, new SocketStateCode[0]),
    ERROR_ILLEGAL_STATE_CHANGE(41, new SocketStateCode[0]),
    ERROR_SYNC_STATE_SESSION(42, new SocketStateCode[0]);

    private final byte id;
    private final Set<SocketStateCode> validBeforeStateSet;
    private static final Set<SocketStateCode> ALL_STATE_CODES;

    private SocketStateCode(byte id, SocketStateCode ... validBeforeStates) {
        this.id = id;
        this.validBeforeStateSet = this.asSet(validBeforeStates);
    }

    private Set<SocketStateCode> asSet(SocketStateCode[] validBeforeStates) {
        if (ArrayUtils.isEmpty(validBeforeStates)) {
            return Collections.emptySet();
        }
        HashSet<SocketStateCode> temp = new HashSet<SocketStateCode>();
        Collections.addAll(temp, validBeforeStates);
        return temp;
    }

    public boolean canChangeState(SocketStateCode nextState) {
        if (this.isError(this)) {
            return false;
        }
        Set<SocketStateCode> validBeforeStateSet = nextState.getValidBeforeStateSet();
        if (validBeforeStateSet.contains((Object)this)) {
            return true;
        }
        return this.isError(nextState);
    }

    public boolean isBeforeConnected() {
        return SocketStateCode.isBeforeConnected(this);
    }

    public static boolean isBeforeConnected(SocketStateCode code) {
        switch (code) {
            case NONE: 
            case BEING_CONNECT: {
                return true;
            }
        }
        return false;
    }

    public boolean isRun() {
        return SocketStateCode.isRun(this);
    }

    public static boolean isRun(SocketStateCode code) {
        switch (code) {
            case RUN_WITHOUT_HANDSHAKE: 
            case RUN_SIMPLEX: 
            case RUN_DUPLEX: {
                return true;
            }
        }
        return false;
    }

    public boolean isRunDuplex() {
        return SocketStateCode.isRunDuplex(this);
    }

    public static boolean isRunDuplex(SocketStateCode code) {
        switch (code) {
            case RUN_DUPLEX: {
                return true;
            }
        }
        return false;
    }

    public boolean onClose() {
        return SocketStateCode.onClose(this);
    }

    public static boolean onClose(SocketStateCode code) {
        switch (code) {
            case BEING_CLOSE_BY_CLIENT: 
            case BEING_CLOSE_BY_SERVER: {
                return true;
            }
        }
        return false;
    }

    public boolean isClosed() {
        return SocketStateCode.isClosed(this);
    }

    public static boolean isClosed(SocketStateCode code) {
        switch (code) {
            case CLOSED_BY_CLIENT: 
            case UNEXPECTED_CLOSE_BY_CLIENT: 
            case CLOSED_BY_SERVER: 
            case UNEXPECTED_CLOSE_BY_SERVER: 
            case ERROR_UNKNOWN: 
            case ERROR_ILLEGAL_STATE_CHANGE: 
            case ERROR_SYNC_STATE_SESSION: {
                return true;
            }
        }
        return false;
    }

    private boolean isError(SocketStateCode code) {
        switch (code) {
            case ERROR_UNKNOWN: 
            case ERROR_ILLEGAL_STATE_CHANGE: {
                return true;
            }
        }
        return false;
    }

    public static SocketStateCode getStateCode(byte id) {
        for (SocketStateCode code : ALL_STATE_CODES) {
            if (code.id != id) continue;
            return code;
        }
        return null;
    }

    public byte getId() {
        return this.id;
    }

    private Set<SocketStateCode> getValidBeforeStateSet() {
        return this.validBeforeStateSet;
    }

    static {
        ALL_STATE_CODES = EnumSet.allOf(SocketStateCode.class);
    }
}

