/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timeout;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.TimerTask;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.rpc.client.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.cluster.Role;
import com.navercorp.pinpoint.rpc.control.ProtocolException;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakePacket;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakeResponsePacket;
import com.navercorp.pinpoint.rpc.packet.HandshakeResponseCode;
import com.navercorp.pinpoint.rpc.util.ClassUtils;
import com.navercorp.pinpoint.rpc.util.ControlMessageEncodingUtils;
import com.navercorp.pinpoint.rpc.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class PinpointClientHandshaker {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final ChannelFutureListener handShakeFailFutureListener = new WriteFailFutureListener(this.logger, "HandShakePacket write fail.", "HandShakePacket write success.");
    private static final int STATE_INIT = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_FINISHED = 2;
    private final AtomicInteger state;
    private final AtomicInteger handshakeCount;
    private final Timer handshakerTimer;
    private final int retryInterval;
    private final int maxHandshakeCount;
    private final Object lock = new Object();
    private final AtomicReference<HandshakeResponseCode> handshakeResult = new AtomicReference<Object>(null);
    private final AtomicReference<ClusterOption> clusterOption = new AtomicReference<Object>(null);
    private String simpleName;

    public PinpointClientHandshaker(Timer handshakerTimer, int retryInterval, int maxHandshakeCount) {
        Assert.requireNonNull(handshakerTimer, "handshakerTimer must not be null.");
        Assert.isTrue(retryInterval > 0, "retryInterval must greater than zero.");
        Assert.isTrue(maxHandshakeCount > 0, "maxHandshakeCount must greater than zero.");
        this.state = new AtomicInteger(0);
        this.handshakerTimer = handshakerTimer;
        this.retryInterval = retryInterval;
        this.maxHandshakeCount = maxHandshakeCount;
        this.handshakeCount = new AtomicInteger(0);
    }

    public void handshakeStart(Channel channel, Map<String, Object> handshakeData) {
        this.logger.info("{} handshakeStart() started. channel:{}", (Object)this.simpleClassNameAndHashCodeString(), (Object)channel);
        if (channel == null) {
            this.logger.warn("{} handshakeStart() failed. caused:channel must not be null.", (Object)this.simpleClassNameAndHashCodeString());
            return;
        }
        if (!channel.isConnected()) {
            this.logger.warn("{} handshakeStart() failed. caused:channel is not connected.", (Object)this.simpleClassNameAndHashCodeString());
            return;
        }
        if (!this.state.compareAndSet(0, 1)) {
            this.logger.warn("{} handshakeStart() failed. caused:unexpected state.", (Object)this.simpleClassNameAndHashCodeString());
            return;
        }
        HandshakeJob handshakeJob = null;
        try {
            handshakeJob = this.createHandshakeJob(channel, handshakeData);
        }
        catch (Exception e) {
            this.logger.warn("{} create HandshakeJob failed. caused:{}", this.simpleClassNameAndHashCodeString(), e.getMessage(), e);
        }
        if (handshakeJob == null) {
            this.logger.warn("{} handshakeStart() failed. caused:handshakeJob must not be null.", (Object)this.simpleClassNameAndHashCodeString());
            this.handshakeAbort();
            return;
        }
        this.handshake(handshakeJob);
        this.reserveHandshake(handshakeJob);
        this.logger.info("{} handshakeStart() completed. channel:{}, data:{}", this.simpleClassNameAndHashCodeString(), channel, handshakeData);
    }

    private HandshakeJob createHandshakeJob(Channel channel, Map<String, Object> handshakeData) throws ProtocolException {
        byte[] payload = ControlMessageEncodingUtils.encode(handshakeData);
        ControlHandshakePacket handshakePacket = new ControlHandshakePacket(payload);
        HandshakeJob handshakeJob = new HandshakeJob(channel, handshakePacket);
        return handshakeJob;
    }

    private void handshake(HandshakeJob handshakeJob) {
        this.handshakeCount.incrementAndGet();
        Channel channel = handshakeJob.getChannel();
        ControlHandshakePacket packet = handshakeJob.getHandshakePacket();
        this.logger.info("{} do handshake({}/{}). channel:{}.", this.simpleClassNameAndHashCodeString(), this.handshakeCount.get(), this.maxHandshakeCount, channel);
        if (channel.isWritable()) {
            ChannelFuture future = channel.write(packet);
            future.addListener(this.handShakeFailFutureListener);
        } else {
            this.logger.error("{} do handshake, channel isWritable is false ({}/{}). channel:{}.", this.simpleClassNameAndHashCodeString(), this.handshakeCount.get(), this.maxHandshakeCount, channel);
        }
    }

    private void reserveHandshake(HandshakeJob handshake) {
        if (this.handshakeCount.get() >= this.maxHandshakeCount) {
            this.logger.warn("{} reserveHandshake() failed. caused:Retry count is over({}/{}).", this.simpleClassNameAndHashCodeString(), this.handshakeCount.get(), this.maxHandshakeCount);
            this.handshakeAbort();
            return;
        }
        this.logger.debug("{} reserveHandshake() started.", (Object)this.simpleClassNameAndHashCodeString());
        this.handshakerTimer.newTimeout(handshake, this.retryInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handshakeComplete(ControlHandshakeResponsePacket responsePacket) {
        this.logger.info("{} handshakeComplete() started. responsePacket:{}", (Object)this.simpleClassNameAndHashCodeString(), (Object)responsePacket);
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.compareAndSet(1, 2)) {
                this.logger.info("{} handshakeComplete() failed. caused:unexpected state.", (Object)this.simpleClassNameAndHashCodeString());
                this.state.set(2);
                return false;
            }
            Map handshakeResponse = this.decode(responsePacket);
            HandshakeResponseCode code = this.getResponseCode(handshakeResponse);
            this.handshakeResult.compareAndSet(null, code);
            ClusterOption clusterOption = this.getClusterOption(handshakeResponse);
            this.clusterOption.compareAndSet(null, clusterOption);
            this.logger.info("{} handshakeComplete() completed. handshake-response:{}.", (Object)this.simpleClassNameAndHashCodeString(), (Object)handshakeResponse);
            return true;
        }
    }

    private Map decode(ControlHandshakeResponsePacket message) {
        byte[] payload = message.getPayload();
        if (payload == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            Map result = (Map)ControlMessageEncodingUtils.decode(payload);
            return result;
        }
        catch (ProtocolException protocolException) {
            return Collections.EMPTY_MAP;
        }
    }

    private HandshakeResponseCode getResponseCode(Map handshakeResponse) {
        if (handshakeResponse == Collections.EMPTY_MAP) {
            return HandshakeResponseCode.PROTOCOL_ERROR;
        }
        int code = MapUtils.getInteger(handshakeResponse, "code", -1);
        int subCode = MapUtils.getInteger(handshakeResponse, "subCode", -1);
        return HandshakeResponseCode.getValue(code, subCode);
    }

    private ClusterOption getClusterOption(Map handshakeResponse) {
        if (handshakeResponse == Collections.EMPTY_MAP) {
            return ClusterOption.DISABLE_CLUSTER_OPTION;
        }
        Map cluster = (Map)handshakeResponse.get("cluster");
        if (cluster == null) {
            return ClusterOption.DISABLE_CLUSTER_OPTION;
        }
        String id = MapUtils.getString(cluster, "id", "");
        List<Role> roles = this.getRoles((List)cluster.get("roles"));
        if (StringUtils.isEmpty(id)) {
            return ClusterOption.DISABLE_CLUSTER_OPTION;
        }
        return new ClusterOption(true, id, roles);
    }

    private List<Role> getRoles(List roleNames) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Object roleName : roleNames) {
            if (!(roleName instanceof String) || !StringUtils.hasLength((String)roleName)) continue;
            roles.add(Role.getValue((String)roleName));
        }
        return roles;
    }

    public HandshakeResponseCode getHandshakeResult() {
        return this.handshakeResult.get();
    }

    public ClusterOption getClusterOption() {
        return this.clusterOption.get();
    }

    public void handshakeAbort() {
        this.logger.info("{} handshakeAbort() started.", (Object)this.simpleClassNameAndHashCodeString());
        if (!this.state.compareAndSet(1, 2)) {
            this.logger.info("{} unexpected state", (Object)this.simpleClassNameAndHashCodeString());
            this.state.set(2);
            return;
        }
        this.logger.info("{} handshakeAbort() completed.", (Object)this.simpleClassNameAndHashCodeString());
    }

    public boolean isRun() {
        int currentState = this.currentState();
        return this.isRun(currentState);
    }

    private boolean isRun(int currentState) {
        return currentState == 1;
    }

    public boolean isFinished() {
        int currentState = this.currentState();
        return this.isFinished(currentState);
    }

    private boolean isFinished(int currentState) {
        return currentState == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int currentState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.get();
        }
    }

    private String simpleClassNameAndHashCodeString() {
        if (this.simpleName == null) {
            this.simpleName = ClassUtils.simpleClassNameAndHashCodeString(this);
        }
        return this.simpleName;
    }

    private class HandshakeJob
    implements TimerTask {
        private final Channel channel;
        private final ControlHandshakePacket handshakePacket;

        public HandshakeJob(Channel channel, ControlHandshakePacket handshakePacket) {
            this.channel = channel;
            this.handshakePacket = handshakePacket;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            PinpointClientHandshaker.this.logger.debug("{} HandshakeJob started.", (Object)PinpointClientHandshaker.this.simpleClassNameAndHashCodeString());
            if (timeout.isCancelled()) {
                PinpointClientHandshaker.this.reserveHandshake(this);
                return;
            }
            int currentState = PinpointClientHandshaker.this.currentState();
            if (PinpointClientHandshaker.this.isRun(currentState)) {
                PinpointClientHandshaker.this.handshake(this);
                PinpointClientHandshaker.this.reserveHandshake(this);
            } else if (PinpointClientHandshaker.this.isFinished(currentState)) {
                PinpointClientHandshaker.this.logger.info("{} HandshakeJob completed.", (Object)PinpointClientHandshaker.this.simpleClassNameAndHashCodeString());
            } else {
                PinpointClientHandshaker.this.logger.warn("{} HandshakeJob will be stop. caused:unexpected state.", (Object)PinpointClientHandshaker.this.simpleClassNameAndHashCodeString());
            }
        }

        public Channel getChannel() {
            return this.channel;
        }

        public ControlHandshakePacket getHandshakePacket() {
            return this.handshakePacket;
        }
    }
}

