/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.bootstrap.ClientBootstrap;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelPipelineException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioClientBossPool;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioWorkerPool;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.HashedWheelTimer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timeout;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.TimerTask;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.client.ConnectFuture;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClient;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.PinpointClientPipelineFactory;
import com.navercorp.pinpoint.rpc.client.ReconnectStateClientHandler;
import com.navercorp.pinpoint.rpc.client.SimpleMessageListener;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.cluster.Role;
import com.navercorp.pinpoint.rpc.stream.DisabledServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.util.LoggerFactorySetup;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultPinpointClientFactory
implements PinpointClientFactory {
    public static final String CONNECT_TIMEOUT_MILLIS = "connectTimeoutMillis";
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final long DEFAULT_TIMEOUTMILLIS = 3000L;
    private static final long DEFAULT_PING_DELAY = 300000L;
    private static final long DEFAULT_ENABLE_WORKER_PACKET_DELAY = 60000L;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final AtomicInteger socketId = new AtomicInteger(1);
    private final Timer timer;
    private volatile boolean released;
    private ClientBootstrap bootstrap;
    private Map<String, Object> properties = Collections.emptyMap();
    private long reconnectDelay = 3000L;
    private SocketAddress internalAddress = null;
    private SocketAddress publicAddress = null;
    private volatile boolean isInternal = true;
    private long pingDelay = 300000L;
    private long enableWorkerPacketDelay = 60000L;
    private long timeoutMillis = 3000L;
    private ClusterOption clusterOption = ClusterOption.DISABLE_CLUSTER_OPTION;
    private MessageListener messageListener = SimpleMessageListener.INSTANCE;
    private List<StateChangeEventListener> stateChangeEventListeners = new ArrayList<StateChangeEventListener>();
    private ServerStreamChannelMessageListener serverStreamChannelMessageListener = DisabledServerStreamChannelMessageListener.INSTANCE;

    public DefaultPinpointClientFactory() {
        this(1, 1);
    }

    public DefaultPinpointClientFactory(int bossCount, int workerCount) {
        if (bossCount < 1) {
            throw new IllegalArgumentException("bossCount is negative: " + bossCount);
        }
        Timer timer = this.createTimer();
        ClientBootstrap bootstrap = this.createBootStrap(bossCount, workerCount, timer);
        this.setOptions(bootstrap);
        this.addPipeline(bootstrap);
        this.bootstrap = bootstrap;
        this.timer = timer;
    }

    private Timer createTimer() {
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer("Pinpoint-SocketFactory-Timer", 100L, TimeUnit.MILLISECONDS, 512);
        timer.start();
        return timer;
    }

    private void addPipeline(ClientBootstrap bootstrap) {
        PinpointClientPipelineFactory pinpointClientPipelineFactory = new PinpointClientPipelineFactory(this);
        bootstrap.setPipelineFactory(pinpointClientPipelineFactory);
    }

    private void setOptions(ClientBootstrap bootstrap) {
        bootstrap.setOption(CONNECT_TIMEOUT_MILLIS, 5000);
        bootstrap.setOption("tcpNoDelay", true);
        bootstrap.setOption("keepAlive", true);
        bootstrap.setOption("sendBufferSize", 65536);
        bootstrap.setOption("receiveBufferSize", 65536);
    }

    @Override
    public int getConnectTimeout() {
        return (Integer)this.bootstrap.getOption(CONNECT_TIMEOUT_MILLIS);
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout cannot be a negative number");
        }
        this.bootstrap.setOption(CONNECT_TIMEOUT_MILLIS, connectTimeout);
    }

    @Override
    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    @Override
    public void setReconnectDelay(long reconnectDelay) {
        if (reconnectDelay < 0L) {
            throw new IllegalArgumentException("reconnectDelay cannot be a negative number");
        }
        this.reconnectDelay = reconnectDelay;
    }

    @Override
    public long getPingDelay() {
        return this.pingDelay;
    }

    @Override
    public void setPingDelay(long pingDelay) {
        if (pingDelay < 0L) {
            throw new IllegalArgumentException("pingDelay cannot be a negative number");
        }
        this.pingDelay = pingDelay;
    }

    @Override
    public long getEnableWorkerPacketDelay() {
        return this.enableWorkerPacketDelay;
    }

    @Override
    public void setEnableWorkerPacketDelay(long enableWorkerPacketDelay) {
        if (enableWorkerPacketDelay < 0L) {
            throw new IllegalArgumentException("EnableWorkerPacketDelay cannot be a negative number");
        }
        this.enableWorkerPacketDelay = enableWorkerPacketDelay;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void setTimeoutMillis(long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("timeoutMillis cannot be a negative number");
        }
        this.timeoutMillis = timeoutMillis;
    }

    private ClientBootstrap createBootStrap(int bossCount, int workerCount, Timer timer) {
        this.logger.debug("createBootStrap boss:{}, worker:{}", (Object)bossCount, (Object)workerCount);
        NioClientSocketChannelFactory nioClientSocketChannelFactory = this.createChannelFactory(bossCount, workerCount, timer);
        return new ClientBootstrap(nioClientSocketChannelFactory);
    }

    private NioClientSocketChannelFactory createChannelFactory(int bossCount, int workerCount, Timer timer) {
        ExecutorService boss = Executors.newCachedThreadPool(new PinpointThreadFactory("Pinpoint-Client-Boss", true));
        NioClientBossPool bossPool = new NioClientBossPool(boss, bossCount, timer, ThreadNameDeterminer.CURRENT);
        ExecutorService worker = Executors.newCachedThreadPool(new PinpointThreadFactory("Pinpoint-Client-Worker", true));
        NioWorkerPool workerPool = new NioWorkerPool((Executor)worker, workerCount, ThreadNameDeterminer.CURRENT);
        return new NioClientSocketChannelFactory(bossPool, workerPool);
    }

    @Override
    public PinpointClient connect(String host, int port) throws PinpointSocketException {
        InetSocketAddress connectAddress = new InetSocketAddress(host, port);
        return this.connect(connectAddress);
    }

    @Override
    public PinpointClient connect(InetSocketAddress connectAddress) throws PinpointSocketException {
        ChannelFuture connectFuture = this.bootstrap.connect(connectAddress);
        PinpointClientHandler pinpointClientHandler = this.getSocketHandler(connectFuture, connectAddress);
        DefaultPinpointClient pinpointClient = new DefaultPinpointClient(pinpointClientHandler);
        this.traceSocket(pinpointClient);
        return pinpointClient;
    }

    @Override
    public PinpointClient reconnect(String host, int port) throws PinpointSocketException {
        InetSocketAddress address = new InetSocketAddress(host, port);
        ChannelFuture connectFuture = this.bootstrap.connect(address);
        PinpointClientHandler pinpointClientHandler = this.getSocketHandler(connectFuture, address);
        DefaultPinpointClient pinpointClient = new DefaultPinpointClient(pinpointClientHandler);
        this.traceSocket(pinpointClient);
        return pinpointClient;
    }

    private void traceSocket(PinpointClient pinpointClient) {
    }

    @Override
    public PinpointClient scheduledConnect(String host, int port) {
        InetSocketAddress connectAddress = new InetSocketAddress(host, port);
        return this.scheduledConnect(connectAddress);
    }

    @Override
    public PinpointClient scheduledConnect(InetSocketAddress connectAddress) {
        DefaultPinpointClient pinpointClient = new DefaultPinpointClient(new ReconnectStateClientHandler());
        this.reconnect(pinpointClient, connectAddress);
        return pinpointClient;
    }

    @Override
    public void setInternalAddress(InetSocketAddress internalAddress) {
        this.internalAddress = internalAddress;
    }

    @Override
    public void setPublicAddress(InetSocketAddress publicAddress) {
        this.publicAddress = publicAddress;
    }

    PinpointClientHandler getSocketHandler(ChannelFuture channelConnectFuture, SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        PinpointClientHandler pinpointClientHandler = this.getSocketHandler(channelConnectFuture.getChannel());
        pinpointClientHandler.setConnectSocketAddress(address);
        ConnectFuture handlerConnectFuture = pinpointClientHandler.getConnectFuture();
        handlerConnectFuture.awaitUninterruptibly();
        if (ConnectFuture.Result.FAIL == handlerConnectFuture.getResult()) {
            throw new PinpointSocketException("connect fail to " + address + ".", channelConnectFuture.getCause());
        }
        return pinpointClientHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture reconnect(SocketAddress remoteAddress) {
        ChannelPipeline pipeline;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        ClientBootstrap bootstrap = this.bootstrap;
        try {
            pipeline = bootstrap.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        DefaultPinpointClientHandler pinpointClientHandler = (DefaultPinpointClientHandler)pipeline.getLast();
        pinpointClientHandler.initReconnect();
        Channel ch = bootstrap.getFactory().newChannel(pipeline);
        boolean success = false;
        try {
            ch.getConfig().setOptions(bootstrap.getOptions());
            success = true;
        }
        finally {
            if (!success) {
                ch.close();
            }
        }
        return ch.connect(remoteAddress);
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return this.timer.newTimeout(task, delay, unit);
    }

    private PinpointClientHandler getSocketHandler(Channel channel) {
        return (PinpointClientHandler)((Object)channel.getPipeline().getLast());
    }

    void reconnect(PinpointClient pinpointClient, SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetSocketAddress address = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        ConnectEvent connectEvent = new ConnectEvent(pinpointClient, address);
        this.timer.newTimeout(connectEvent, this.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Set<Timeout> stop;
        DefaultPinpointClientFactory defaultPinpointClientFactory = this;
        synchronized (defaultPinpointClientFactory) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
        if (!(stop = this.timer.stop()).isEmpty()) {
            this.logger.info("stop Timeout:{}", (Object)stop.size());
        }
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> agentProperties) {
        Assert.requireNonNull(this.properties, "agentProperties must not be null");
        this.properties = Collections.unmodifiableMap(agentProperties);
    }

    @Override
    public ClusterOption getClusterOption() {
        return this.clusterOption;
    }

    @Override
    public void setClusterOption(ClusterOption clusterOption) {
        this.clusterOption = clusterOption;
    }

    @Override
    public void setClusterOption(String id, List<Role> roles) {
        this.clusterOption = new ClusterOption(true, id, roles);
    }

    @Override
    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    @Override
    public void setMessageListener(MessageListener messageListener) {
        Assert.requireNonNull(messageListener, "messageListener must not be null");
        this.messageListener = messageListener;
    }

    @Override
    public MessageListener getMessageListener(MessageListener defaultMessageListener) {
        if (this.messageListener == null) {
            return defaultMessageListener;
        }
        return this.messageListener;
    }

    @Override
    public ServerStreamChannelMessageListener getServerStreamChannelMessageListener() {
        return this.serverStreamChannelMessageListener;
    }

    @Override
    public void setServerStreamChannelMessageListener(ServerStreamChannelMessageListener serverStreamChannelMessageListener) {
        Assert.requireNonNull(this.messageListener, "messageListener must not be null");
        this.serverStreamChannelMessageListener = serverStreamChannelMessageListener;
    }

    @Override
    public ServerStreamChannelMessageListener getServerStreamChannelMessageListener(ServerStreamChannelMessageListener defaultStreamMessageListener) {
        if (this.serverStreamChannelMessageListener == null) {
            return defaultStreamMessageListener;
        }
        return this.serverStreamChannelMessageListener;
    }

    @Override
    public List<StateChangeEventListener> getStateChangeEventListeners() {
        return new ArrayList<StateChangeEventListener>(this.stateChangeEventListeners);
    }

    @Override
    public void addStateChangeEventListener(StateChangeEventListener stateChangeEventListener) {
        this.stateChangeEventListeners.add(stateChangeEventListener);
    }

    boolean isReleased() {
        return this.released;
    }

    int issueNewSocketId() {
        return this.socketId.getAndIncrement();
    }

    static {
        LoggerFactorySetup.setupSlf4jLoggerFactory();
    }

    private class ConnectEvent
    implements TimerTask {
        private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
        private final PinpointClient pinpointClient;
        private SocketAddress socketAddress;

        private ConnectEvent(PinpointClient pinpointClient, SocketAddress socketAddress) {
            if (pinpointClient == null) {
                throw new NullPointerException("pinpointClient must not be null");
            }
            if (socketAddress == null) {
                throw new NullPointerException("socketAddress must not be null");
            }
            this.pinpointClient = pinpointClient;
            this.socketAddress = socketAddress;
        }

        @Override
        public void run(Timeout timeout) {
            if (timeout.isCancelled()) {
                return;
            }
            if (this.pinpointClient.isClosed()) {
                this.logger.debug("pinpointClient is already closed.");
                return;
            }
            this.logger.warn("try reconnect. connectAddress:{}", (Object)this.socketAddress);
            ChannelFuture channelFuture = DefaultPinpointClientFactory.this.reconnect(this.socketAddress);
            Channel channel = channelFuture.getChannel();
            final PinpointClientHandler pinpointClientHandler = DefaultPinpointClientFactory.this.getSocketHandler(channel);
            pinpointClientHandler.setConnectSocketAddress(this.socketAddress);
            pinpointClientHandler.setPinpointClient(this.pinpointClient);
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Channel channel = future.getChannel();
                        ConnectEvent.this.logger.info("reconnect success {}, {}", (Object)ConnectEvent.this.socketAddress, (Object)channel);
                        ConnectEvent.this.pinpointClient.reconnectSocketHandler(pinpointClientHandler);
                    } else if (!ConnectEvent.this.pinpointClient.isClosed()) {
                        if (DefaultPinpointClientFactory.this.internalAddress != null) {
                            if (DefaultPinpointClientFactory.this.isInternal) {
                                ConnectEvent.this.socketAddress = DefaultPinpointClientFactory.this.internalAddress;
                            } else {
                                ConnectEvent.this.socketAddress = DefaultPinpointClientFactory.this.publicAddress;
                            }
                            DefaultPinpointClientFactory.this.isInternal = !DefaultPinpointClientFactory.this.isInternal;
                        }
                        DefaultPinpointClientFactory.this.reconnect(ConnectEvent.this.pinpointClient, ConnectEvent.this.socketAddress);
                    } else {
                        ConnectEvent.this.logger.info("pinpointClient is closed. stop reconnect.");
                    }
                }
            });
        }
    }
}

