/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;

public class UnsupportOperationMessageListener
implements MessageListener {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final UnsupportOperationMessageListener INSTANCE = new UnsupportOperationMessageListener();

    @Override
    public void handleSend(SendPacket sendPacket, PinpointSocket pinpointSocket) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Unsupported handleSend method");
        errorMessage.append("packet:").append(sendPacket);
        errorMessage.append(", remote::").append(pinpointSocket.getRemoteAddress());
        throw new UnsupportedOperationException(errorMessage.toString());
    }

    @Override
    public void handleRequest(RequestPacket requestPacket, PinpointSocket pinpointSocket) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Unsupported handleRequest method");
        errorMessage.append("packet:").append(requestPacket);
        errorMessage.append(", remote::").append(pinpointSocket.getRemoteAddress());
        throw new UnsupportedOperationException(errorMessage.toString());
    }

    public static UnsupportOperationMessageListener getInstance() {
        return INSTANCE;
    }
}

