/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    private static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 64;
    private static final String NULL_STRING = "NullPointerException";

    public StringUtils() {
        throw new AssertionError();
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmptyOrNull(String string) {
        return string == null || string.isEmpty() || "null".equals(string);
    }

    public static boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean hasText(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static <T> int getLength(String string) {
        return StringUtils.getLength(string, 0);
    }

    public static <T> int getLength(String string, int nullValue) {
        if (string == null) {
            return nullValue;
        }
        return string.length();
    }

    public static String toString(Object object) {
        if (object == null) {
            return NULL_STRING;
        }
        return object.toString();
    }

    public static String abbreviate(String str) {
        return StringUtils.abbreviate(str, 64);
    }

    public static String newAbbreviate(String str, int maxWidth) {
        if (str == null) {
            return NULL_STRING;
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("negative maxWidth:" + maxWidth);
        }
        if (str.length() > maxWidth) {
            StringBuilder buffer = new StringBuilder(maxWidth + 10);
            buffer.append(str, 0, maxWidth);
            return buffer.toString();
        }
        return str;
    }

    public static String abbreviate(String str, int maxWidth) {
        if (str == null) {
            return NULL_STRING;
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("negative maxWidth:" + maxWidth);
        }
        if (str.length() > maxWidth) {
            StringBuilder buffer = new StringBuilder(maxWidth + 10);
            buffer.append(str, 0, maxWidth);
            StringUtils.appendAbbreviateMessage(buffer, str.length());
            return buffer.toString();
        }
        return str;
    }

    public static void appendAbbreviate(StringBuilder builder, String str, int maxWidth) {
        if (str == null) {
            return;
        }
        if (maxWidth < 0) {
            return;
        }
        if (str.length() > maxWidth) {
            builder.append(str, 0, maxWidth);
            StringUtils.appendAbbreviateMessage(builder, str.length());
        } else {
            builder.append(str);
        }
    }

    private static void appendAbbreviateMessage(StringBuilder buffer, int strLength) {
        buffer.append("...");
    }

    public static List<String> tokenizeToStringList(String str, String delimiters) {
        return StringUtils.tokenizeToStringList(str, delimiters, true, true);
    }

    public static List<String> tokenizeToStringList(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }
}

