/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import java.util.EnumSet;
import java.util.Set;

public enum JvmVersion {
    JAVA_5(1.5f, 49),
    JAVA_6(1.6f, 50),
    JAVA_7(1.7f, 51),
    JAVA_8(1.8f, 52),
    UNSUPPORTED(-1.0f, -1);

    private final float version;
    private final int classVersion;
    private static final Set<JvmVersion> JVM_VERSION;
    private static final IntHashMap<JvmVersion> CLASS_VERSION_MAP;

    private JvmVersion(float version, int classVersion) {
        this.version = version;
        this.classVersion = classVersion;
    }

    public boolean onOrAfter(JvmVersion other) {
        if (this == UNSUPPORTED || other == UNSUPPORTED) {
            return false;
        }
        return this == other || this.version > other.version;
    }

    public static JvmVersion getFromVersion(String javaVersion) {
        try {
            float version = Float.parseFloat(javaVersion);
            return JvmVersion.getFromVersion(version);
        }
        catch (NumberFormatException e) {
            return UNSUPPORTED;
        }
    }

    @Deprecated
    public static JvmVersion getFromVersion(double javaVersion) {
        return JvmVersion.getFromVersion((float)javaVersion);
    }

    public static JvmVersion getFromVersion(float javaVersion) {
        for (JvmVersion version : JVM_VERSION) {
            if (Float.compare(version.version, javaVersion) != 0) continue;
            return version;
        }
        return UNSUPPORTED;
    }

    private static IntHashMap<JvmVersion> toClassVersionMap() {
        IntHashMap<JvmVersion> jvmVersionIntHashMap = new IntHashMap<JvmVersion>();
        for (JvmVersion version : JvmVersion.values()) {
            jvmVersionIntHashMap.put(version.classVersion, version);
        }
        return jvmVersionIntHashMap;
    }

    public static JvmVersion getFromClassVersion(int classVersion) {
        JvmVersion jvmVersion = CLASS_VERSION_MAP.get(classVersion);
        if (jvmVersion == null) {
            return UNSUPPORTED;
        }
        return jvmVersion;
    }

    static {
        JVM_VERSION = EnumSet.allOf(JvmVersion.class);
        CLASS_VERSION_MAP = JvmVersion.toClassVersionMap();
    }
}

