/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.ClassLoaderUtils;

public final class ClassUtils {
    private static final Object CLASS_NOT_LOADED = null;
    private static final char PACKAGE_SEPARATOR = '.';

    private ClassUtils() {
    }

    public static boolean isLoaded(String name) {
        return ClassUtils.isLoaded(name, ClassLoaderUtils.getDefaultClassLoader());
    }

    public static boolean isLoaded(String name, ClassLoader classLoader) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassLoaderUtils.getDefaultClassLoader();
        }
        try {
            return classLoaderToUse.loadClass(name) != CLASS_NOT_LOADED;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getPackageName(String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException("fully-qualified class name must not be null");
        }
        int lastPackageSeparatorIndex = fqcn.lastIndexOf(46);
        if (lastPackageSeparatorIndex == -1) {
            return "";
        }
        return fqcn.substring(0, lastPackageSeparatorIndex);
    }

    public static String toInternalName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name must not be null");
        }
        return className.replace('.', '/');
    }
}

