/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.Charsets;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class BytesUtils {
    public static final int SHORT_BYTE_LENGTH = 2;
    public static final int INT_BYTE_LENGTH = 4;
    public static final int LONG_BYTE_LENGTH = 8;
    public static final int LONG_LONG_BYTE_LENGTH = 16;
    public static final int VLONG_MAX_SIZE = 10;
    public static final int VINT_MAX_SIZE = 5;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Charset UTF8_CHARSET = Charsets.UTF_8;
    private static final String UTF8 = Charsets.UTF_8_NAME;

    private BytesUtils() {
    }

    public static byte[] stringLongLongToBytes(String string, int maxStringSize, long value1, long value2) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (maxStringSize < 0) {
            throw new IndexOutOfBoundsException("maxStringSize");
        }
        byte[] stringBytes = BytesUtils.toBytes(string);
        if (stringBytes.length > maxStringSize) {
            throw new IndexOutOfBoundsException("string is max " + stringBytes.length + ", string='" + string + "'");
        }
        byte[] buffer = new byte[16 + maxStringSize];
        BytesUtils.writeBytes(buffer, 0, stringBytes);
        BytesUtils.writeFirstLong0(value1, buffer, maxStringSize);
        BytesUtils.writeSecondLong0(value2, buffer, maxStringSize);
        return buffer;
    }

    public static int writeBytes(byte[] buffer, int bufferOffset, byte[] srcBytes) {
        if (srcBytes == null) {
            throw new NullPointerException("srcBytes must not be null");
        }
        return BytesUtils.writeBytes(buffer, bufferOffset, srcBytes, 0, srcBytes.length);
    }

    public static int writeBytes(byte[] buffer, int bufferOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        if (buffer == null) {
            throw new NullPointerException("buffer must not be null");
        }
        if (srcBytes == null) {
            throw new NullPointerException("stringBytes must not be null");
        }
        if (bufferOffset < 0) {
            throw new IndexOutOfBoundsException("negative bufferOffset:" + bufferOffset);
        }
        if (srcOffset < 0) {
            throw new IndexOutOfBoundsException("negative srcOffset offset:" + srcOffset);
        }
        System.arraycopy(srcBytes, srcOffset, buffer, bufferOffset, srcLength);
        return bufferOffset + srcLength;
    }

    public static long bytesToLong(byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (buf.length < offset + 8) {
            throw new IndexOutOfBoundsException("buf.length is too small. buf.length:" + buf.length + " offset:" + (offset + 8));
        }
        long rv = ((long)buf[offset] & 0xFFL) << 56 | ((long)buf[offset + 1] & 0xFFL) << 48 | ((long)buf[offset + 2] & 0xFFL) << 40 | ((long)buf[offset + 3] & 0xFFL) << 32 | ((long)buf[offset + 4] & 0xFFL) << 24 | ((long)buf[offset + 5] & 0xFFL) << 16 | ((long)buf[offset + 6] & 0xFFL) << 8 | (long)buf[offset + 7] & 0xFFL;
        return rv;
    }

    public static int bytesToInt(byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (buf.length < offset + 4) {
            throw new IndexOutOfBoundsException("buf.length is too small. buf.length:" + buf.length + " offset:" + (offset + 4));
        }
        int v = (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
        return v;
    }

    public static short bytesToShort(byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (buf.length < offset + 2) {
            throw new IndexOutOfBoundsException("buf.length is too small. buf.length:" + buf.length + " offset:" + (offset + 2));
        }
        short v = (short)((buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF);
        return v;
    }

    public static int bytesToSVar32(byte[] buffer, int offset) {
        return BytesUtils.zigzagToInt(BytesUtils.bytesToVar32(buffer, offset));
    }

    public static int bytesToVar32(byte[] buffer, int offset) {
        block5: {
            int x;
            block7: {
                int pos;
                block9: {
                    block8: {
                        block6: {
                            if (buffer == null) {
                                throw new NullPointerException("buffer must not be null");
                            }
                            BytesUtils.checkBound(buffer.length, offset);
                            pos = offset;
                            int bufferSize = buffer.length;
                            if (bufferSize == pos) break block5;
                            if ((x = buffer[pos++]) >= 0) {
                                return x;
                            }
                            if (bufferSize - pos < 9) break block5;
                            if ((x ^= buffer[pos++] << 7) >= 0) break block6;
                            x ^= 0xFFFFFF80;
                            break block7;
                        }
                        if ((x ^= buffer[pos++] << 14) < 0) break block8;
                        x ^= 0x3F80;
                        break block7;
                    }
                    if ((x ^= buffer[pos++] << 21) >= 0) break block9;
                    x ^= 0xFFE03F80;
                    break block7;
                }
                byte y = buffer[pos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos] < 0) break block5;
            }
            return x;
        }
        return (int)BytesUtils.readVar64SlowPath(buffer, offset);
    }

    public static long bytesToSVar64(byte[] buffer, int offset) {
        return BytesUtils.zigzagToLong(BytesUtils.bytesToVar64(buffer, offset));
    }

    public static long bytesToVar64(byte[] buffer, int offset) {
        block5: {
            long x;
            block7: {
                int pos;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block6: {
                                            byte y;
                                            if (buffer == null) {
                                                throw new NullPointerException("buffer must not be null");
                                            }
                                            BytesUtils.checkBound(buffer.length, offset);
                                            pos = offset;
                                            int bufferSize = buffer.length;
                                            if (bufferSize == pos) break block5;
                                            if ((y = buffer[pos++]) >= 0) {
                                                return y;
                                            }
                                            if (bufferSize - pos < 9) break block5;
                                            if ((x = (long)(y ^ buffer[pos++] << 7)) >= 0L) break block6;
                                            x ^= 0xFFFFFFFFFFFFFF80L;
                                            break block7;
                                        }
                                        if ((x ^= (long)(buffer[pos++] << 14)) < 0L) break block8;
                                        x ^= 0x3F80L;
                                        break block7;
                                    }
                                    if ((x ^= (long)(buffer[pos++] << 21)) >= 0L) break block9;
                                    x ^= 0xFFFFFFFFFFE03F80L;
                                    break block7;
                                }
                                if ((x ^= (long)buffer[pos++] << 28) < 0L) break block10;
                                x ^= 0xFE03F80L;
                                break block7;
                            }
                            if ((x ^= (long)buffer[pos++] << 35) >= 0L) break block11;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block7;
                        }
                        if ((x ^= (long)buffer[pos++] << 42) < 0L) break block12;
                        x ^= 0x3F80FE03F80L;
                        break block7;
                    }
                    if ((x ^= (long)buffer[pos++] << 49) >= 0L) break block13;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block7;
                }
                x ^= (long)buffer[pos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[pos] < 0L) break block5;
            }
            return x;
        }
        return BytesUtils.readVar64SlowPath(buffer, offset);
    }

    static long readVar64SlowPath(byte[] buffer, int offset) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer[offset++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalArgumentException("invalid varLong. start offset:" + offset + " readOffset:" + offset);
    }

    public static short bytesToShort(byte byte1, byte byte2) {
        return (short)((byte1 & 0xFF) << 8 | byte2 & 0xFF);
    }

    public static int writeLong(long value, byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (buf.length < offset + 8) {
            throw new IndexOutOfBoundsException("buf.length is too small. buf.length:" + buf.length + " offset:" + (offset + 8));
        }
        buf[offset++] = (byte)(value >> 56);
        buf[offset++] = (byte)(value >> 48);
        buf[offset++] = (byte)(value >> 40);
        buf[offset++] = (byte)(value >> 32);
        buf[offset++] = (byte)(value >> 24);
        buf[offset++] = (byte)(value >> 16);
        buf[offset++] = (byte)(value >> 8);
        buf[offset++] = (byte)value;
        return offset;
    }

    public static int writeShort(short value, byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (buf.length < offset + 2) {
            throw new IndexOutOfBoundsException("buf.length is too small. buf.length:" + buf.length + " offset:" + (offset + 2));
        }
        buf[offset++] = (byte)(value >> 8);
        buf[offset++] = (byte)value;
        return offset;
    }

    public static int writeInt(int value, byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (buf.length < offset + 4) {
            throw new IndexOutOfBoundsException("buf.length is too small. buf.length:" + buf.length + " offset:" + (offset + 4));
        }
        buf[offset++] = (byte)(value >> 24);
        buf[offset++] = (byte)(value >> 16);
        buf[offset++] = (byte)(value >> 8);
        buf[offset++] = (byte)value;
        return offset;
    }

    public static int writeSVar32(int value, byte[] buf, int offset) {
        return BytesUtils.writeVar32(BytesUtils.intToZigZag(value), buf, offset);
    }

    public static int writeVar32(int value, byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        BytesUtils.checkBound(buf.length, offset);
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buf[offset++] = (byte)value;
                return offset;
            }
            buf[offset++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int shortToUnsignedShort(short value) {
        return value & 0xFFFF;
    }

    public static byte[] intToSVar32(int value) {
        return BytesUtils.intToVar32(BytesUtils.intToZigZag(value));
    }

    public static byte[] intToVar32(int value) {
        int bufferSize = BytesUtils.computeVar32Size(value);
        byte[] buffer = new byte[bufferSize];
        BytesUtils.writeVar64(value, buffer, 0);
        return buffer;
    }

    public static int computeVar32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int writeSVar64(int value, byte[] buf, int offset) {
        return BytesUtils.writeVar64(BytesUtils.longToZigZag(value), buf, offset);
    }

    public static int writeVar64(long value, byte[] buf, int offset) {
        if (buf == null) {
            throw new NullPointerException("buf must not be null");
        }
        BytesUtils.checkBound(buf.length, offset);
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buf[offset++] = (byte)value;
                return offset;
            }
            buf[offset++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    static void checkBound(int bufferLength, int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (offset >= bufferLength) {
            throw new IndexOutOfBoundsException("invalid offset:" + offset + " bufferLength:" + bufferLength);
        }
    }

    public static byte[] longToSVar64(long value) {
        return BytesUtils.longToVar64(BytesUtils.longToZigZag(value));
    }

    public static byte[] longToVar64(long value) {
        int bufferSize = BytesUtils.computeVar64Size(value);
        byte[] buffer = new byte[bufferSize];
        BytesUtils.writeVar64(value, buffer, 0);
        return buffer;
    }

    public static int computeVar64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    private static int writeFirstLong0(long value, byte[] buf, int offset) {
        buf[offset] = (byte)(value >> 56);
        buf[1 + offset] = (byte)(value >> 48);
        buf[2 + offset] = (byte)(value >> 40);
        buf[3 + offset] = (byte)(value >> 32);
        buf[4 + offset] = (byte)(value >> 24);
        buf[5 + offset] = (byte)(value >> 16);
        buf[6 + offset] = (byte)(value >> 8);
        buf[7 + offset] = (byte)value;
        return offset;
    }

    private static int writeSecondLong0(long value, byte[] buf, int offset) {
        buf[8 + offset] = (byte)(value >> 56);
        buf[9 + offset] = (byte)(value >> 48);
        buf[10 + offset] = (byte)(value >> 40);
        buf[11 + offset] = (byte)(value >> 32);
        buf[12 + offset] = (byte)(value >> 24);
        buf[13 + offset] = (byte)(value >> 16);
        buf[14 + offset] = (byte)(value >> 8);
        buf[15 + offset] = (byte)value;
        return offset;
    }

    public static byte[] add(String prefix, long postfix) {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        byte[] agentByte = BytesUtils.toBytes(prefix);
        return BytesUtils.add(agentByte, postfix);
    }

    public static byte[] add(byte[] preFix, long postfix) {
        byte[] buf = new byte[preFix.length + 8];
        System.arraycopy(preFix, 0, buf, 0, preFix.length);
        BytesUtils.writeLong(postfix, buf, preFix.length);
        return buf;
    }

    public static byte[] add(byte[] preFix, short postfix) {
        if (preFix == null) {
            throw new NullPointerException("preFix must not be null");
        }
        byte[] buf = new byte[preFix.length + 2];
        System.arraycopy(preFix, 0, buf, 0, preFix.length);
        BytesUtils.writeShort(postfix, buf, preFix.length);
        return buf;
    }

    public static byte[] add(byte[] preFix, int postfix) {
        if (preFix == null) {
            throw new NullPointerException("preFix must not be null");
        }
        byte[] buf = new byte[preFix.length + 4];
        System.arraycopy(preFix, 0, buf, 0, preFix.length);
        BytesUtils.writeInt(postfix, buf, preFix.length);
        return buf;
    }

    public static byte[] add(int preFix, short postFix) {
        byte[] buf = new byte[6];
        BytesUtils.writeInt(preFix, buf, 0);
        BytesUtils.writeShort(postFix, buf, 4);
        return buf;
    }

    public static byte[] add(long preFix, short postFix) {
        byte[] buf = new byte[10];
        BytesUtils.writeLong(preFix, buf, 0);
        BytesUtils.writeShort(postFix, buf, 8);
        return buf;
    }

    @Deprecated
    public static byte[] add(long preFix, short postFix, int intArg, short shortArg) {
        byte[] buf = new byte[16];
        int offset = 0;
        BytesUtils.writeLong(preFix, buf, offset);
        BytesUtils.writeShort(postFix, buf, offset += 8);
        BytesUtils.writeInt(intArg, buf, offset += 2);
        BytesUtils.writeShort(shortArg, buf, offset += 4);
        return buf;
    }

    public static byte[] toBytes(String value) {
        if (value == null) {
            return null;
        }
        try {
            return value.getBytes(Charsets.UTF_8_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return value.getBytes(Charsets.UTF_8);
        }
    }

    public static byte[] merge(byte[] b1, byte[] b2) {
        if (b1 == null) {
            throw new NullPointerException("b1 must not be null");
        }
        if (b2 == null) {
            throw new NullPointerException("b2 must not be null");
        }
        byte[] result = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        return result;
    }

    public static byte[] toFixedLengthBytes(String str, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length:" + length);
        }
        byte[] b1 = BytesUtils.toBytes(str);
        if (b1 == null) {
            return new byte[length];
        }
        if (b1.length > length) {
            throw new IndexOutOfBoundsException("String is longer then target length of bytes.");
        }
        byte[] b = new byte[length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        return b;
    }

    public static int intToZigZag(int n) {
        return n << 1 ^ n >> 31;
    }

    public static int zigzagToInt(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long longToZigZag(long n) {
        return n << 1 ^ n >> 63;
    }

    public static long zigzagToLong(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static byte[] concat(byte[] ... arrays) {
        int totalLength = 0;
        int length = arrays.length;
        for (int i = 0; i < length; ++i) {
            totalLength += arrays[i].length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (int i = 0; i < length; ++i) {
            System.arraycopy(arrays[i], 0, result, currentIndex, arrays[i].length);
            currentIndex += arrays[i].length;
        }
        return result;
    }

    public static String safeTrim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return BytesUtils.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + offset);
        }
        if (length == 0) {
            return "";
        }
        try {
            return new String(bytes, offset, length, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, offset, length, UTF8_CHARSET);
        }
    }

    public static String toStringAndRightTrim(byte[] bytes, int offset, int length) {
        String string = BytesUtils.toString(bytes, offset, length);
        return BytesUtils.trimRight(string);
    }

    public static String trimRight(String string) {
        int length;
        if (string == null) {
            return null;
        }
        int index = length = string.length();
        while (string.charAt(index - 1) <= ' ') {
            --index;
        }
        if (index == length) {
            return string;
        }
        return string.substring(0, index);
    }
}

