/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

public final class BitFieldUtils {
    private BitFieldUtils() {
    }

    public static boolean testBit(byte v, int position) {
        return BitFieldUtils.testBit((int)v, position);
    }

    public static boolean testBit(short v, int position) {
        return BitFieldUtils.testBit((int)v, position);
    }

    public static boolean testBit(int v, int position) {
        return (v & 1 << position) != 0;
    }

    public static boolean testBit(long v, int position) {
        return (v & 1L << position) != 0L;
    }

    public static byte clearBit(byte v, int position) {
        return (byte)BitFieldUtils.clearBit((int)v, position);
    }

    public static short clearBit(short v, int position) {
        return (short)BitFieldUtils.clearBit((int)v, position);
    }

    public static int clearBit(int v, int position) {
        return v & ~(1 << position);
    }

    public static long clearBit(long v, int position) {
        return v & (1L << position ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte setBit(byte v, int position, boolean value) {
        return (byte)BitFieldUtils.setBit((int)v, position, value);
    }

    public static short setBit(short v, int position, boolean value) {
        return (short)BitFieldUtils.setBit((int)v, position, value);
    }

    public static int setBit(int v, int position, boolean value) {
        if (value) {
            return v | 1 << position;
        }
        return BitFieldUtils.clearBit(v, position);
    }

    public static long setBit(long v, int position, boolean value) {
        if (value) {
            return v | 1L << position;
        }
        return BitFieldUtils.clearBit(v, position);
    }

    public static int getBit(byte v, int position) {
        return (v & 1 << position) >>> position;
    }

    public static int getBit(short v, int position) {
        return (v & 1 << position) >>> position;
    }

    public static int getBit(int v, int position) {
        return (v & 1 << position) >>> position;
    }

    public static int getBit(long v, int position) {
        return (int)((v & (long)(1 << position)) >>> position);
    }

    public static int get2Bit(int v, int position) {
        return BitFieldUtils.getMultiBit(v, position, 2);
    }

    public static int getMultiBit(int v, int position, int bitSize) {
        int shift = position;
        int mask = 0;
        for (int i = 0; i < bitSize; ++i) {
            mask |= (v & 1 << shift) >>> position;
            ++shift;
        }
        return mask;
    }
}

