/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyFactory;
import com.navercorp.pinpoint.common.trace.AnnotationKeyProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AnnotationKeyUtils {
    public static Map<Integer, AnnotationKey> cache = new ConcurrentHashMap<Integer, AnnotationKey>();

    private AnnotationKeyUtils() {
    }

    public static AnnotationKey getArgs(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index:" + index);
        }
        switch (index) {
            case 0: {
                return AnnotationKey.ARGS0;
            }
            case 1: {
                return AnnotationKey.ARGS1;
            }
            case 2: {
                return AnnotationKey.ARGS2;
            }
            case 3: {
                return AnnotationKey.ARGS3;
            }
            case 4: {
                return AnnotationKey.ARGS4;
            }
            case 5: {
                return AnnotationKey.ARGS5;
            }
            case 6: {
                return AnnotationKey.ARGS6;
            }
            case 7: {
                return AnnotationKey.ARGS7;
            }
            case 8: {
                return AnnotationKey.ARGS8;
            }
            case 9: {
                return AnnotationKey.ARGS9;
            }
        }
        return AnnotationKey.ARGSN;
    }

    public static boolean isArgsKey(int index) {
        return index <= AnnotationKey.ARGS0.getCode() && index >= AnnotationKey.ARGSN.getCode();
    }

    public static AnnotationKey getCachedArgs(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index:" + index);
        }
        switch (index) {
            case 0: {
                return AnnotationKey.CACHE_ARGS0;
            }
            case 1: {
                return AnnotationKey.CACHE_ARGS1;
            }
            case 2: {
                return AnnotationKey.CACHE_ARGS2;
            }
            case 3: {
                return AnnotationKey.CACHE_ARGS3;
            }
            case 4: {
                return AnnotationKey.CACHE_ARGS4;
            }
            case 5: {
                return AnnotationKey.CACHE_ARGS5;
            }
            case 6: {
                return AnnotationKey.CACHE_ARGS6;
            }
            case 7: {
                return AnnotationKey.CACHE_ARGS7;
            }
            case 8: {
                return AnnotationKey.CACHE_ARGS8;
            }
            case 9: {
                return AnnotationKey.CACHE_ARGS9;
            }
        }
        return AnnotationKey.CACHE_ARGSN;
    }

    public static boolean isCachedArgsKey(int index) {
        return index <= AnnotationKey.CACHE_ARGS0.getCode() && index >= AnnotationKey.CACHE_ARGSN.getCode();
    }

    public static int cachedArgsToArgs(int index) {
        if (!AnnotationKeyUtils.isCachedArgsKey(index)) {
            throw new IllegalArgumentException("non CACHED_ARGS:" + index);
        }
        int cachedIndex = AnnotationKey.CACHE_ARGS0.getCode() - AnnotationKey.ARGS0.getCode();
        return index - cachedIndex;
    }

    public static AnnotationKey getScenarioKey(int index) {
        switch (index) {
            case -110: {
                return AnnotationKey.SCENARIO_K0;
            }
            case -111: {
                return AnnotationKey.SCENARIO_K1;
            }
            case -112: {
                return AnnotationKey.SCENARIO_K2;
            }
            case -113: {
                return AnnotationKey.SCENARIO_K3;
            }
            case -114: {
                return AnnotationKey.SCENARIO_K4;
            }
            case -115: {
                return AnnotationKey.SCENARIO_K5;
            }
            case -116: {
                return AnnotationKey.SCENARIO_K6;
            }
            case -117: {
                return AnnotationKey.SCENARIO_K7;
            }
            case -118: {
                return AnnotationKey.SCENARIO_K8;
            }
            case -119: {
                return AnnotationKey.SCENARIO_K9;
            }
        }
        return null;
    }

    public static AnnotationKey getScenarioKey(String key) {
        if (AnnotationKey.SCENARIO_K0.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K0;
        }
        if (AnnotationKey.SCENARIO_K1.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K1;
        }
        if (AnnotationKey.SCENARIO_K2.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K2;
        }
        if (AnnotationKey.SCENARIO_K3.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K3;
        }
        if (AnnotationKey.SCENARIO_K4.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K4;
        }
        if (AnnotationKey.SCENARIO_K5.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K5;
        }
        if (AnnotationKey.SCENARIO_K6.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K6;
        }
        if (AnnotationKey.SCENARIO_K7.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K7;
        }
        if (AnnotationKey.SCENARIO_K8.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K8;
        }
        if (AnnotationKey.SCENARIO_K9.getName().equals(key)) {
            return AnnotationKey.SCENARIO_K9;
        }
        return null;
    }

    public static AnnotationKey getAnnotationKey(String key) {
        if (key == null) {
            return null;
        }
        int hashcode = key.hashCode();
        if (cache.containsKey(hashcode)) {
            return cache.get(hashcode);
        }
        AnnotationKey annotationKey = AnnotationKeyFactory.of(hashcode, key, new AnnotationKeyProperty[0]);
        cache.put(hashcode, annotationKey);
        return annotationKey;
    }
}

