/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.BaseHistogramSchema;
import com.navercorp.pinpoint.common.trace.HistogramSchema;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.EnumSet;
import java.util.Set;

public enum ServiceTypeCategory {
    UNDEFINED_CATEGORY(-1, -1),
    PINPOINT_INTERNAL(0, 999),
    SERVER(1000, 1999),
    DATABASE(2000, 2999),
    LIBRARY(5000, 7999),
    CACHE_LIBRARY(8000, 8999, BaseHistogramSchema.FAST_SCHEMA),
    RPC(9000, 9999);

    private final short minCode;
    private final short maxCode;
    private HistogramSchema histogramSchema;
    private static final Set<ServiceTypeCategory> SERVICE_TYPE_CATEGORIES;

    private ServiceTypeCategory(short minCode, short maxCode) {
        this(minCode, maxCode, BaseHistogramSchema.NORMAL_SCHEMA);
    }

    private ServiceTypeCategory(short minCode, short maxCode, HistogramSchema histogramSchema) {
        this.minCode = minCode;
        this.maxCode = maxCode;
        if (histogramSchema == null) {
            throw new NullPointerException("histogramSchema must not be null");
        }
        this.histogramSchema = histogramSchema;
    }

    public boolean contains(short code) {
        return this.minCode <= code && code <= this.maxCode;
    }

    public boolean contains(ServiceType type) {
        return this.contains(type.getCode());
    }

    public HistogramSchema getHistogramSchema() {
        return this.histogramSchema;
    }

    public static ServiceTypeCategory findCategory(short code) {
        for (ServiceTypeCategory serviceTypeCategory : SERVICE_TYPE_CATEGORIES) {
            if (!serviceTypeCategory.contains(code)) continue;
            return serviceTypeCategory;
        }
        throw new IllegalStateException("Unknown Category code:" + code);
    }

    static {
        SERVICE_TYPE_CATEGORIES = EnumSet.allOf(ServiceTypeCategory.class);
    }
}

