/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.HistogramSchema;
import com.navercorp.pinpoint.common.trace.HistogramSlot;
import com.navercorp.pinpoint.common.trace.SlotType;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;

public class BaseHistogramSchema
implements HistogramSchema {
    public static final HistogramSchema FAST_SCHEMA = new BaseHistogramSchema(1, 100, "100ms", 300, "300ms", 500, "500ms", "Slow", "Error", -100, "100ms", -300, "300ms", -500, "500ms", -999, "Slow");
    public static final HistogramSchema NORMAL_SCHEMA = new BaseHistogramSchema(2, 1000, "1s", 3000, "3s", 5000, "5s", "Slow", "Error", -1000, "1s", -3000, "3s", -5000, "5s", -9999, "Slow");
    private static final IntHashMap<HistogramSchema> DEFAULT_HISTOGRAM_SCHEMA_MAP = new IntHashMap();
    private static final short VERY_SLOW_SLOT_TIME = 0;
    private static final short ERROR_SLOT_TIME = -1;
    private final int typeCode;
    private final HistogramSlot fastSlot;
    private final HistogramSlot normalSlot;
    private final HistogramSlot slowSlot;
    private final HistogramSlot verySlowSlot;
    private final HistogramSlot errorSlot;
    private final HistogramSlot fastErrorSlot;
    private final HistogramSlot normalErrorSlot;
    private final HistogramSlot slowErrorSlot;
    private final HistogramSlot verySlowErrorSlot;

    private BaseHistogramSchema(int typeCode, short fast, String fastName, short normal, String normalName, short slow, String slowName, String verySlowName, String errorName, short fastError, String fastErrorName, short normalError, String normalErrorName, short slowError, String slowErrorName, short verySlowError, String verySlowErrorName) {
        this.typeCode = typeCode;
        this.fastSlot = new HistogramSlot(fast, SlotType.FAST, fastName);
        this.fastErrorSlot = new HistogramSlot(fastError, SlotType.FAST_ERROR, fastErrorName);
        this.normalSlot = new HistogramSlot(normal, SlotType.NORMAL, normalName);
        this.errorSlot = new HistogramSlot(-1, SlotType.ERROR, errorName);
        this.normalErrorSlot = new HistogramSlot(normalError, SlotType.NORMAL_ERROR, normalErrorName);
        this.slowSlot = new HistogramSlot(slow, SlotType.SLOW, slowName);
        this.slowErrorSlot = new HistogramSlot(slowError, SlotType.SLOW_ERROR, slowErrorName);
        this.verySlowSlot = new HistogramSlot(0, SlotType.VERY_SLOW, verySlowName);
        this.verySlowErrorSlot = new HistogramSlot(verySlowError, SlotType.VERY_SLOW_ERROR, verySlowErrorName);
    }

    @Override
    public int getTypeCode() {
        return this.typeCode;
    }

    @Override
    public HistogramSlot findHistogramSlot(int elapsedTime, boolean error) {
        if (elapsedTime <= this.fastSlot.getSlotTime()) {
            return error ? this.fastErrorSlot : this.fastSlot;
        }
        if (elapsedTime <= this.normalSlot.getSlotTime()) {
            return error ? this.normalErrorSlot : this.normalSlot;
        }
        if (elapsedTime <= this.slowSlot.getSlotTime()) {
            return error ? this.slowErrorSlot : this.slowSlot;
        }
        return error ? this.verySlowErrorSlot : this.verySlowSlot;
    }

    @Override
    public HistogramSlot getFastSlot() {
        return this.fastSlot;
    }

    @Override
    public HistogramSlot getNormalSlot() {
        return this.normalSlot;
    }

    @Override
    public HistogramSlot getSlowSlot() {
        return this.slowSlot;
    }

    @Override
    public HistogramSlot getVerySlowSlot() {
        return this.verySlowSlot;
    }

    @Override
    public HistogramSlot getErrorSlot() {
        return this.errorSlot;
    }

    @Override
    public HistogramSlot getFastErrorSlot() {
        return this.fastErrorSlot;
    }

    @Override
    public HistogramSlot getNormalErrorSlot() {
        return this.normalErrorSlot;
    }

    @Override
    public HistogramSlot getSlowErrorSlot() {
        return this.slowErrorSlot;
    }

    @Override
    public HistogramSlot getVerySlowErrorSlot() {
        return this.verySlowErrorSlot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.typeCode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistogramSchema other = (HistogramSchema)obj;
        return this.typeCode == other.getTypeCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("typeCode=").append(this.typeCode);
        sb.append(", fastSlot=").append(this.fastSlot);
        sb.append(", normalSlot=").append(this.normalSlot);
        sb.append(", slowSlot=").append(this.slowSlot);
        sb.append(", verySlowSlot=").append(this.verySlowSlot);
        sb.append(", errorSlot=").append(this.errorSlot);
        sb.append(", fastErrorSlot=").append(this.fastErrorSlot);
        sb.append(", normalErrorSlot=").append(this.normalErrorSlot);
        sb.append(", slowErrorSlot=").append(this.slowErrorSlot);
        sb.append(", verySlowErrorSlot=").append(this.verySlowErrorSlot);
        sb.append('}');
        return sb.toString();
    }

    public static HistogramSchema getDefaultHistogramSchemaByTypeCode(int typeCode) {
        return DEFAULT_HISTOGRAM_SCHEMA_MAP.get(typeCode);
    }

    static {
        DEFAULT_HISTOGRAM_SCHEMA_MAP.put(FAST_SCHEMA.getTypeCode(), FAST_SCHEMA);
        DEFAULT_HISTOGRAM_SCHEMA_MAP.put(NORMAL_SCHEMA.getTypeCode(), NORMAL_SCHEMA);
    }
}

