/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.service;

import com.navercorp.pinpoint.common.arms.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.arms.util.logger.CommonLoggerFactory;
import com.navercorp.pinpoint.common.arms.util.logger.StdoutCommonLoggerFactory;
import com.navercorp.pinpoint.common.service.AnnotationKeyRegistryService;
import com.navercorp.pinpoint.common.service.DefaultTraceMetadataLoaderService;
import com.navercorp.pinpoint.common.service.TraceMetadataLoaderService;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyRegistry;
import com.navercorp.pinpoint.common.util.StaticFieldLookUp;
import java.util.List;

public class DefaultAnnotationKeyRegistryService
implements AnnotationKeyRegistryService {
    private final CommonLogger logger;
    private final TraceMetadataLoaderService typeLoaderService;
    private final AnnotationKeyRegistry registry;

    public DefaultAnnotationKeyRegistryService() {
        this(new DefaultTraceMetadataLoaderService(), StdoutCommonLoggerFactory.INSTANCE);
    }

    public DefaultAnnotationKeyRegistryService(TraceMetadataLoaderService typeLoaderService, CommonLoggerFactory commonLogger) {
        if (typeLoaderService == null) {
            throw new NullPointerException("typeLoaderService must not be null");
        }
        if (commonLogger == null) {
            throw new NullPointerException("commonLogger must not be null");
        }
        this.logger = commonLogger.getLogger(DefaultAnnotationKeyRegistryService.class.getName());
        this.typeLoaderService = typeLoaderService;
        this.registry = this.buildAnnotationKeyRegistry();
    }

    private AnnotationKeyRegistry buildAnnotationKeyRegistry() {
        AnnotationKeyRegistry.Builder builder = new AnnotationKeyRegistry.Builder();
        StaticFieldLookUp<AnnotationKey> staticFieldLookUp = new StaticFieldLookUp<AnnotationKey>(AnnotationKey.class, AnnotationKey.class);
        List<AnnotationKey> lookup = staticFieldLookUp.lookup();
        for (AnnotationKey serviceType : lookup) {
            builder.addAnnotationKey(serviceType);
        }
        List<AnnotationKey> types = this.typeLoaderService.getAnnotationKeys();
        for (AnnotationKey type : types) {
            builder.addAnnotationKey(type);
        }
        return builder.build();
    }

    @Override
    public AnnotationKey findAnnotationKey(int annotationCode) {
        return this.registry.findAnnotationKey(annotationCode);
    }

    @Override
    public AnnotationKey findAnnotationKeyByName(String keyName) {
        return this.registry.findAnnotationKeyByName(keyName);
    }

    @Override
    public AnnotationKey findApiErrorCode(int annotationCode) {
        return this.registry.findApiErrorCode(annotationCode);
    }
}

