/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.buffer;

import com.navercorp.pinpoint.common.buffer.FixedBuffer;
import java.nio.ByteBuffer;

public class OffsetFixedBuffer
extends FixedBuffer {
    protected int startOffset;
    protected int endOffset;

    public OffsetFixedBuffer(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public OffsetFixedBuffer(byte[] buffer, int startOffset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer must not be null");
        }
        if (startOffset < 0) {
            throw new IndexOutOfBoundsException("negative startOffset:" + startOffset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length:" + length);
        }
        if (startOffset > buffer.length) {
            throw new IndexOutOfBoundsException("startOffset:" + startOffset + " > buffer.length:" + buffer.length);
        }
        int endOffset = startOffset + length;
        if (endOffset > buffer.length) {
            throw new IndexOutOfBoundsException("too large length buffer.length:" + buffer.length + " endOffset:" + endOffset);
        }
        this.buffer = buffer;
        this.offset = startOffset;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public byte[] getBuffer() {
        if (this.startOffset == 0 && this.offset == this.buffer.length) {
            return this.buffer;
        }
        return this.copyBuffer();
    }

    @Override
    public byte[] copyBuffer() {
        int length = this.offset - this.startOffset;
        byte[] copy = new byte[length];
        System.arraycopy(this.buffer, this.startOffset, copy, 0, length);
        return copy;
    }

    @Override
    public ByteBuffer wrapByteBuffer() {
        int length = this.offset - this.startOffset;
        return ByteBuffer.wrap(this.buffer, this.startOffset, length);
    }

    @Override
    public int remaining() {
        return this.endOffset - this.offset;
    }

    @Override
    public boolean hasRemaining() {
        return this.offset < this.endOffset;
    }
}

