/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.util;

import com.navercorp.pinpoint.common.arms.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class FormatUtils {
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateMinuteFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateHourFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd_HH");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateTimeMillisFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            format.setLenient(false);
            return format;
        }
    };
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(FormatUtils.DATE_FORMAT);
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> pageDateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> yyyyMMddFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> gmtDateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> secondTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> minuteTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal<DecimalFormat> roundx2Formatter = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat format = new DecimalFormat("0.00");
            return format;
        }
    };
    private static final ThreadLocal<DecimalFormat> roundx4Formatter = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat format = new DecimalFormat("0.0000");
            return format;
        }
    };
    private static final long KB_SIZE = 1024L;
    private static final long MB_SIZE = 0x100000L;
    private static final long GB_SIZE = 0x40000000L;
    private static final long TB_SIZE = 0x10000000000L;
    private static final long PB_SIZE = 0x4000000000000L;
    private static final long[] TIME_SPANS_MILLIS = new long[]{TimeUnit.DAYS.toMillis(1L), TimeUnit.HOURS.toMillis(1L), TimeUnit.MINUTES.toMillis(1L), TimeUnit.SECONDS.toMillis(1L), 1L};
    private static final String[] TIME_SPANS_TEXT = new String[]{"d", "h", "m", "s", "ms"};
    private static final String[] TIME_SPANS_CHINESE_TEXT = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
    private static final long A_HUNDRED_MILLION = 100000000L;
    private static final long TEN_THOUSAND = 10000L;

    public static Date parseDateTime(String dateTimeString) throws IllegalArgumentException {
        try {
            return dateTimeFormatter.get().parse(dateTimeString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm:ss", e);
        }
    }

    public static String toDateTimeString(long millis) throws IllegalArgumentException {
        return dateTimeFormatter.get().format(new Date(millis));
    }

    public static String toDateTimeString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return dateTimeFormatter.get().format(date);
    }

    public static Date parseDateMinute(String dateTimeString) throws IllegalArgumentException {
        try {
            return dateMinuteFormatter.get().parse(dateTimeString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm", e);
        }
    }

    public static String toDateMinuteString(long millis) throws IllegalArgumentException {
        return dateMinuteFormatter.get().format(new Date(millis));
    }

    public static String toDateMinuteString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return dateMinuteFormatter.get().format(date);
    }

    public static Date parseDateHour(String dateStr) {
        Date date;
        try {
            date = dateHourFormat.get().parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u975e\u6cd5\u65f6\u95f4\uff1a" + dateStr + "\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3a yyyy-MM-dd_HH", e);
        }
        return date;
    }

    public static String toDateHourString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return dateHourFormat.get().format(date);
    }

    public static Date parseDateTimeMillis(String dateTimeString) throws IllegalArgumentException {
        try {
            return dateTimeMillisFormatter.get().parse(dateTimeString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm:ss.SSS", e);
        }
    }

    public static String toDateTimeMillisString(long millis) throws IllegalArgumentException {
        return dateTimeMillisFormatter.get().format(new Date(millis));
    }

    public static String toDateTimeMillisString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return dateTimeMillisFormatter.get().format(date);
    }

    public static Date parseDate(String dateString) throws IllegalArgumentException {
        try {
            return dateFormatter.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd", e);
        }
    }

    public static String toDateString(long millis) throws IllegalArgumentException {
        return dateFormatter.get().format(new Date(millis));
    }

    public static String toDateString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return dateFormatter.get().format(date);
    }

    public static Date parseTimeRangeDate(String dateStr) {
        Date date;
        try {
            date = formatter.get().parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u975e\u6cd5\u65f6\u95f4\uff1a" + dateStr + "\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3a " + DATE_FORMAT);
        }
        return date;
    }

    public static String formatTimeRange(Date date) {
        return formatter.get().format(date);
    }

    public static String toPageDateString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return pageDateFormatter.get().format(date);
    }

    public static String toPageDateString(long time) throws IllegalArgumentException {
        return pageDateFormatter.get().format(time);
    }

    public static Date parsePageDate(String dateString) throws IllegalArgumentException {
        try {
            return pageDateFormatter.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyy/MM/dd", e);
        }
    }

    public static Date parseYyyyMMdd(String dateString) throws IllegalArgumentException {
        try {
            return yyyyMMddFormatter.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyyMMdd", e);
        }
    }

    public static String toYyyyMMddString(long millis) throws IllegalArgumentException {
        return yyyyMMddFormatter.get().format(new Date(millis));
    }

    public static String toYyyyMMddString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return yyyyMMddFormatter.get().format(date);
    }

    public static Date parseGmtDate(String dateString) throws IllegalArgumentException {
        try {
            return gmtDateFormatter.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1aEEE, dd MMM yyyy HH:mm:ss zzz", e);
        }
    }

    public static String toGmtDateString(long millis) throws IllegalArgumentException {
        return gmtDateFormatter.get().format(new Date(millis));
    }

    public static Date parseSecondTime(String dateString) throws IllegalArgumentException {
        try {
            return secondTimeFormatter.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1aHH:mm:ss", e);
        }
    }

    public static String toSecondTimeString(long millis) throws IllegalArgumentException {
        return secondTimeFormatter.get().format(new Date(millis));
    }

    public static Date parseMinuteTime(String dateString) throws IllegalArgumentException {
        try {
            return minuteTimeFormatter.get().parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1aHH:mm", e);
        }
    }

    public static String toMinuteTimeString(long millis) throws IllegalArgumentException {
        return minuteTimeFormatter.get().format(new Date(millis));
    }

    public static String toGmtDateString(Date date) throws IllegalArgumentException {
        if (date == null) {
            return null;
        }
        return gmtDateFormatter.get().format(date);
    }

    public static double round(double value, int decimals) {
        double d = Math.pow(10.0, decimals);
        return (double)Math.round(value * d) / d;
    }

    public static long roundx0(double value) {
        return Math.round(value);
    }

    public static double roundx1(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    public static double roundx2(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static double roundx3(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }

    public static String roundx4(double value) {
        return roundx4Formatter.get().format(value);
    }

    public static String humanReadableByteSize(String bytes) {
        try {
            Long lbytes = Long.valueOf(bytes);
            return FormatUtils.humanReadableByteSize(lbytes);
        }
        catch (Exception e) {
            return "\u672a\u77e5";
        }
    }

    public static String humanReadableByteSize(long bytes) {
        String result;
        long fix;
        boolean negative = bytes < 0L;
        long l = fix = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (fix > 0x4000000000000L) {
            double pb = (double)fix / 1.125899906842624E15;
            result = FormatUtils.roundx1(pb) + "PB";
        } else if (fix > 0x10000000000L) {
            double tb = (double)fix / 1.099511627776E12;
            result = FormatUtils.roundx1(tb) + "TB";
        } else if (fix > 0x40000000L) {
            double gb = (double)fix / 1.073741824E9;
            result = FormatUtils.roundx1(gb) + "GB";
        } else if (fix > 0x100000L) {
            double mb = (double)fix / 1048576.0;
            result = FormatUtils.roundx1(mb) + "MB";
        } else if (fix > 1024L) {
            double kb = (double)fix / 1024.0;
            result = FormatUtils.roundx1(kb) + "KB";
        } else {
            result = fix + "B";
        }
        return negative ? "-" + result : result;
    }

    public static String humanReadableTimeSpan(String millis) {
        try {
            Long lmillis = Long.valueOf(millis);
            return FormatUtils.humanReadableTimeSpan(lmillis);
        }
        catch (NumberFormatException e) {
            return "\u672a\u77e5";
        }
    }

    public static String humanReadableTimeSpan(long millis) {
        return FormatUtils.humanReadableTimeSpan(millis, 2, TIME_SPANS_TEXT);
    }

    public static String humanReadableChineseTimeSpan(String millis) {
        try {
            Long lmillis = Long.valueOf(millis);
            return FormatUtils.humanReadableChineseTimeSpan(lmillis);
        }
        catch (Exception e) {
            return "\u672a\u77e5";
        }
    }

    public static String humanReadableChineseTimeSpan(long millis) {
        return FormatUtils.humanReadableTimeSpan(millis, 2, TIME_SPANS_CHINESE_TEXT);
    }

    private static String humanReadableTimeSpan(long millis, int maxTimeUnit, String[] textLabels) {
        boolean negative = millis < 0L;
        long fix = millis == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(millis);
        int appendUnit = 0;
        StringBuilder appender = new StringBuilder();
        if (negative) {
            appender.append('-');
        }
        int l = TIME_SPANS_MILLIS.length;
        for (int i = 0; i < l && fix > 0L; ++i) {
            long span = TIME_SPANS_MILLIS[i];
            if (fix < span) continue;
            long unit = fix / span;
            fix %= span;
            appender.append(unit).append(textLabels[i]);
            if (++appendUnit < maxTimeUnit) continue;
            return appender.toString();
        }
        if (appender.length() == 0) {
            appender.append(fix).append(textLabels[l - 1]);
        }
        return appender.toString();
    }

    public static String humanReadableFormat(String obj) {
        String result = null;
        try {
            result = FormatUtils.humanReadableNumber(Long.parseLong(obj));
        }
        catch (NumberFormatException e) {
            result = FormatUtils.humanReadablePercent(Double.parseDouble(obj));
        }
        return result;
    }

    public static String humanReadableFormat(long obj) {
        return FormatUtils.humanReadableNumber(obj);
    }

    public static String humanReadableFormat(double obj) {
        return FormatUtils.humanReadablePercent(obj);
    }

    public static String humanReadableNumber(String number) {
        try {
            Long lnumber = Long.valueOf(number);
            return FormatUtils.humanReadableNumber(lnumber);
        }
        catch (Exception e) {
            return "\u672a\u77e5";
        }
    }

    public static String humanReadableNumber(long number) {
        return FormatUtils.humanReadableNumber(number, 2);
    }

    public static String humanReadablePercent(String number) {
        try {
            Double dnumber = Double.valueOf(number);
            return FormatUtils.humanReadablePercent(dnumber);
        }
        catch (Exception e) {
            return "\u672a\u77e5";
        }
    }

    public static String humanReadablePercent(double number) {
        return String.format("%.2f", number * 100.0) + "%";
    }

    public static String humanReadableLargeNumber(String number) {
        try {
            Double dnumber = Double.valueOf(number);
            return FormatUtils.humanReadableLargeNumber(dnumber);
        }
        catch (Exception e) {
            return "\u672a\u77e5";
        }
    }

    public static String humanReadableLargeNumber(double number) {
        if (number >= 10000.0) {
            return FormatUtils.humanReadableNumber((long)number);
        }
        return String.valueOf(FormatUtils.roundx2(number));
    }

    public static String humanReadableNumber(long number, int maxUnit) {
        long x;
        boolean negative = number < 0L;
        long fix = number == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(number);
        StringBuilder appender = new StringBuilder();
        if (negative) {
            appender.append('-');
        }
        int appendUnit = 0;
        if (fix >= 100000000L) {
            x = fix / 100000000L;
            fix %= 100000000L;
            appender.append(x).append('\u4ebf');
            ++appendUnit;
        }
        if (fix >= 10000L) {
            x = fix / 10000L;
            fix %= 10000L;
            appender.append(x).append('\u4e07');
            if (++appendUnit >= maxUnit) {
                return appender.toString();
            }
        }
        if (appendUnit < maxUnit && (fix > 0L || appender.length() == 0)) {
            appender.append(fix);
        }
        return appender.toString();
    }

    public static final String join(int[] array, String delim) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(delim).append(array[i]);
        }
        return builder.toString();
    }

    public static final String join(long[] array, String delim) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(delim).append(array[i]);
        }
        return builder.toString();
    }

    public static final String join(Object[] array, String delim) {
        return array == null ? "" : FormatUtils.join(array, 0, array.length, delim);
    }

    public static final String join(Object[] array, int startPos, int endPos, String delim) {
        if (CommonUtils.isNullEmpty(array) || startPos >= endPos) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(array[startPos].toString());
        for (int i = startPos + 1; i < endPos; ++i) {
            builder.append(delim).append(array[i].toString());
        }
        return builder.toString();
    }

    public static final String join(Collection<?> cl, String delim) {
        if (CommonUtils.isNullEmpty(cl)) {
            return "";
        }
        return FormatUtils.join(cl.iterator(), delim);
    }

    public static String join(Iterator<?> it, String delim) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(it.next().toString());
        while (it.hasNext()) {
            builder.append(delim).append(it.next().toString());
        }
        return builder.toString();
    }

    public static final String truncateWithEllipsis(String str, int length) {
        if (str == null || str.length() < length || length < 4) {
            return str;
        }
        return str.substring(0, length - 3) + "...";
    }

    public static final String diffTime(long num, long base) {
        long diff = num - base;
        return diff == 0L ? "+0ms" : (diff > 0L ? "+" + FormatUtils.humanReadableTimeSpan(diff) : FormatUtils.humanReadableTimeSpan(diff));
    }

    public static final String urlEncode(String url) {
        if (!CommonUtils.isNullEmpty(url)) {
            try {
                return URLEncoder.encode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return url;
    }

    public static final String percent(double dividend, double divisor) {
        return divisor != 0.0 ? FormatUtils.percent(dividend / divisor) : (dividend != 0.0 ? "-" : "0.00%");
    }

    public static final String percent(double value) {
        if (value < 5.0E-5 && value > -5.0E-5) {
            return "0.00%";
        }
        return FormatUtils.roundx2(value * 100.0) + "%";
    }

    public static final String percentX(double dividend, double divisor) {
        return divisor != 0.0 ? FormatUtils.percentX(dividend / divisor) : (dividend != 0.0 ? "-" : "0.00");
    }

    public static final String percentX(double value) {
        if (value > 1.0) {
            return String.valueOf(roundx2Formatter.get().format(value));
        }
        if (value < 5.0E-5 && value > -5.0E-5) {
            return "0.00";
        }
        return String.valueOf(roundx2Formatter.get().format(value * 100.0));
    }

    public static final String percentx0(double dividend, double divisor) {
        return divisor != 0.0 ? FormatUtils.percentx0(dividend / divisor) : (dividend != 0.0 ? "-" : "0%");
    }

    public static final String percentx0(double value) {
        if (value < 0.005 && value > -0.005) {
            return "0%";
        }
        return FormatUtils.roundx0(value * 100.0) + "%";
    }

    public static final String percentx1(double dividend, double divisor) {
        return divisor != 0.0 ? FormatUtils.percentx1(dividend / divisor) : (dividend != 0.0 ? "-" : "0.0%");
    }

    public static final String percentx1(double value) {
        if (value < 5.0E-4 && value > -5.0E-4) {
            return "0.0%";
        }
        return FormatUtils.roundx1(value * 100.0) + "%";
    }

    public static final String escapeToUnicodeString(char c) {
        return "\\u" + Integer.toHexString(c | 0x10000).substring(1);
    }

    public static final String getIdentityCode(Object obj) {
        if (obj == null) {
            return "(null)";
        }
        return "(0x" + Integer.toHexString(System.identityHashCode(obj)) + ")";
    }

    public static final void appendWithSoftLineBreak(StringBuilder appender, String str, int start, int end, int step) {
        int inc = 0;
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            if (inc < step) {
                ++inc;
            } else if (inc == step && c >= 'A' && c <= 'Z') {
                appender.append("&#8203;");
                inc = 0;
            }
            appender.append(c);
        }
    }

    public static final float abs(float a) {
        return Math.abs(a);
    }

    public static final String getExceptionStackTrace(Exception e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        e.printStackTrace(pw);
        pw.close();
        return new String(out.toByteArray());
    }

    public static void main(String[] args) {
        System.out.println(FormatUtils.humanReadableNumber(0L));
    }
}

