/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.Appender;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerDispatch;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class RollingFileAppender
extends Appender {
    private static final long LOG_FLUSH_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private int maxBackupIndex = 3;
    private final long maxFileSize;
    private final int bufferSize;
    private final String filePath;
    private final AtomicBoolean isRolling = new AtomicBoolean(false);
    private BufferedOutputStream bos = null;
    private long nextFlushTime = 0L;
    private long lastRollOverTime = 0L;
    private long outputByteSize = 0L;
    private final boolean selfLogEnabled;
    private boolean multiProcessDetected = false;
    private static final String DELETE_FILE_SUBFIX = ".deleted";
    private static final int MAX_BUFFER_LOG_SIZE = 4096;
    private static final int MAX_CONTENT_SIZE = 0xA00000;

    public RollingFileAppender(String filePath, long maxFileSize) {
        this(filePath, maxFileSize, true);
    }

    public RollingFileAppender(String filePath, long maxFileSize, boolean selfLogEnabled) {
        this.bufferSize = 4096;
        this.filePath = filePath;
        this.maxFileSize = maxFileSize;
        this.selfLogEnabled = selfLogEnabled;
        this.setFile();
    }

    private void setFile() {
        try {
            File logFile = new File(this.filePath);
            if (!logFile.exists()) {
                File parentFile = logFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    this.doSelfLog("[ERROR] Fail to mkdirs: " + parentFile.getAbsolutePath());
                    return;
                }
                try {
                    if (!logFile.createNewFile()) {
                        this.doSelfLog("[ERROR] Fail to create file, it exists: " + logFile.getAbsolutePath());
                    }
                }
                catch (IOException var4) {
                    this.doSelfLog("[ERROR] Fail to create file: " + logFile.getAbsolutePath() + ", error=" + var4.getMessage());
                }
            }
            if (!logFile.isFile() || !logFile.canWrite()) {
                this.doSelfLog("[ERROR] Invalid file, exists=" + logFile.exists() + ", isFile=" + logFile.isFile() + ", canWrite=" + logFile.canWrite() + ", path=" + logFile.getAbsolutePath());
                return;
            }
            FileOutputStream ostream = new FileOutputStream(logFile, true);
            this.bos = new BufferedOutputStream(ostream, 4096);
            this.lastRollOverTime = System.currentTimeMillis();
            this.outputByteSize = logFile.length();
        }
        catch (Throwable var5) {
            this.doSelfLog("[ERROR] Fail to create file to write: " + this.filePath + ", error=" + var5.getMessage());
        }
    }

    @Override
    public void append(String log) {
        BufferedOutputStream bos = this.bos;
        if (bos != null) {
            try {
                this.waitUntilRollFinish();
                byte[] bytes = log.getBytes(ArmsLoggerDispatch.DEFAULT_CHARSET);
                int current_len = 0;
                int total_len = bytes.length;
                if (total_len < 0xA00000) {
                    if (total_len > 4096 && this.multiProcessDetected) {
                        for (int current_start = 0; current_start < total_len; current_start += current_len) {
                            int prefix = total_len - current_start;
                            current_len = prefix > 4096 ? 4096 : prefix;
                            bos.write(bytes, current_start, current_len);
                        }
                    } else {
                        bos.write(bytes, 0, total_len);
                    }
                    this.outputByteSize += (long)total_len;
                    if (this.outputByteSize >= this.maxFileSize) {
                        this.rollOver();
                    } else if (System.currentTimeMillis() >= this.nextFlushTime) {
                        this.flush();
                    }
                } else {
                    this.doSelfLog("[ERROR] single log is larger than 10MB " + this.filePath + " info: " + log.substring(0, 30));
                }
            }
            catch (Exception var5) {
                this.doSelfLog("[ERROR] fail to write log to file " + this.filePath + ", error=" + var5.getMessage());
                this.close();
                this.setFile();
            }
        }
    }

    @Override
    public void flush() {
        BufferedOutputStream bos = this.bos;
        if (bos != null) {
            try {
                bos.flush();
                this.nextFlushTime = System.currentTimeMillis() + LOG_FLUSH_INTERVAL;
            }
            catch (Exception var3) {
                this.doSelfLog("[WARN] Fail to flush OutputStream: " + this.filePath + ", " + var3.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollOver() {
        String lockFilePath = this.filePath + ".lock";
        File lockFile = new File(lockFilePath);
        RandomAccessFile raf = null;
        FileLock fileLock = null;
        if (this.isRolling.compareAndSet(false, true)) {
            try {
                raf = new RandomAccessFile(lockFile, "rw");
                fileLock = raf.getChannel().tryLock();
                if (fileLock != null) {
                    int maxBackupIndex = this.maxBackupIndex;
                    this.reload();
                    if (this.outputByteSize >= this.maxFileSize) {
                        File target;
                        File file = new File(this.filePath + '.' + maxBackupIndex);
                        if (file.exists() && !file.renameTo(target = new File(this.filePath + '.' + maxBackupIndex + DELETE_FILE_SUBFIX)) && !file.delete()) {
                            this.doSelfLog("[ERROR] Fail to delete or rename file: " + file.getAbsolutePath() + " to " + target.getAbsolutePath());
                        }
                        for (int i = maxBackupIndex - 1; i >= 1; --i) {
                            file = new File(this.filePath + '.' + i);
                            if (!file.exists() || file.renameTo(target = new File(this.filePath + '.' + (i + 1))) || file.delete()) continue;
                            this.doSelfLog("[ERROR] Fail to delete or rename file: " + file.getAbsolutePath() + " to " + target.getAbsolutePath());
                        }
                        target = new File(this.filePath + "." + 1);
                        this.close();
                        file = new File(this.filePath);
                        if (file.renameTo(target)) {
                            this.doSelfLog("[INFO] File rolled to " + target.getAbsolutePath() + ", " + TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.lastRollOverTime) + " minutes since last roll");
                        } else {
                            this.doSelfLog("[WARN] Fail to rename file: " + file.getAbsolutePath() + " to " + target.getAbsolutePath());
                        }
                        this.setFile();
                    }
                }
            }
            catch (IOException var21) {
                this.doSelfLog("[ERROR] Fail rollover file: " + this.filePath + ", error=" + var21.getMessage());
            }
            finally {
                this.isRolling.set(false);
                if (fileLock != null) {
                    try {
                        fileLock.release();
                    }
                    catch (IOException var20) {
                        this.doSelfLog("[ERROR] Fail to release file lock: " + lockFilePath + ", error=" + var20.getMessage());
                    }
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException var19) {
                        this.doSelfLog("[WARN] Fail to close file lock: " + lockFilePath + ", error=" + var19.getMessage());
                    }
                }
                if (fileLock != null && !lockFile.delete() && lockFile.exists()) {
                    this.doSelfLog("[WARN] Fail to delete file lock: " + lockFilePath);
                }
            }
        }
    }

    @Override
    public void close() {
        BufferedOutputStream bos = this.bos;
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException var3) {
                this.doSelfLog("[WARN] Fail to close OutputStream: " + var3.getMessage());
            }
            this.bos = null;
        }
    }

    @Override
    public void reload() {
        boolean fileNotExists;
        this.flush();
        File logFile = new File(this.filePath);
        long fileSize = logFile.length();
        boolean bl = fileNotExists = fileSize <= 0L && !logFile.exists();
        if (this.bos != null && fileSize >= this.outputByteSize && !fileNotExists) {
            if (fileSize > this.outputByteSize) {
                this.outputByteSize = fileSize;
                if (!this.multiProcessDetected) {
                    this.multiProcessDetected = true;
                    if (this.selfLogEnabled) {
                        this.doSelfLog("[WARN] Multi-process file write detected: " + this.filePath);
                    }
                }
            }
        } else {
            if (fileSize < this.outputByteSize) {
                this.doSelfLog("[INFO] Log file rolled over by outside: " + this.filePath + ", force reload");
            }
            this.close();
            this.setFile();
        }
    }

    @Override
    public void cleanup() {
        try {
            String baseFileName;
            File[] filesToDelete;
            File logFile = new File(this.filePath);
            File parentDir = logFile.getParentFile();
            if (parentDir != null && parentDir.isDirectory() && (filesToDelete = parentDir.listFiles(new FilenameFilter(baseFileName = logFile.getName()){
                final /* synthetic */ String val$baseFileName;
                {
                    this.val$baseFileName = string;
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith(this.val$baseFileName) && name.endsWith(RollingFileAppender.DELETE_FILE_SUBFIX);
                }
            })) != null && filesToDelete.length > 0) {
                File[] arr$ = filesToDelete;
                int len$ = filesToDelete.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    boolean success;
                    File f = arr$[i$];
                    boolean bl = success = f.delete() || !f.exists();
                    if (success) {
                        this.doSelfLog("[INFO] Deleted log file: " + f.getAbsolutePath());
                        continue;
                    }
                    if (!f.exists()) continue;
                    this.doSelfLog("[ERROR] Fail to delete log file: " + f.getAbsolutePath());
                }
            }
        }
        catch (Exception var10) {
            this.doSelfLog("[ERROR] Fail to cleanup log file, error=" + var10.getMessage());
        }
    }

    void waitUntilRollFinish() {
        while (this.isRolling.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    private void doSelfLog(String log) {
        if (this.selfLogEnabled) {
            ArmsLoggerDispatch.selfLog(log);
        } else {
            System.out.println("[ARMS Logger]" + log);
        }
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        if (maxBackupIndex < 1) {
            throw new IllegalArgumentException("maxBackupIndex < 1: " + maxBackupIndex);
        }
        this.maxBackupIndex = maxBackupIndex;
    }

    @Override
    public String getOutputLocation() {
        return this.filePath;
    }

    public String toString() {
        return "RollingFileAppender [filePath=" + this.filePath + "]";
    }
}

