/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.Appender;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerDispatch;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerUtils;
import com.navercorp.pinpoint.common.arms.logger.BaseContext;
import com.navercorp.pinpoint.common.arms.logger.BaseContextEncoder;
import com.navercorp.pinpoint.common.arms.logger.FastException;
import com.navercorp.pinpoint.common.arms.logger.NoOpAppender;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

class AsyncAppender
extends Appender {
    private static final int DEFAULT_NOTIFY_THRESHOLD = 512;
    private static final int DO_EVENT_NOTIFY = Integer.MIN_VALUE;
    static final int LOG_TYPE_EVENT_FLUSH = -1;
    static final int LOG_TYPE_EVENT_ROLLOVER = -2;
    static final int LOG_TYPE_EVENT_RELOAD = -3;
    static final int LOG_TYPE_EVENT_CLOSE = -4;
    private final BaseContext[] entries;
    private final int queueSize;
    private final int indexMask;
    private final int notifyThreshold;
    private final int maxWaitMillis;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private AtomicLong putIndex;
    private AtomicLong discardCount;
    private AtomicLong takeIndex;
    private Appender appender;
    private BaseContextEncoder encoder;
    private String workerName;
    private Thread worker;
    private AtomicBoolean running;

    public AsyncAppender(int queueSize, int maxWaitMillis) {
        this.queueSize = queueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.maxWaitMillis = maxWaitMillis;
        this.entries = new BaseContext[queueSize];
        this.indexMask = queueSize - 1;
        this.notifyThreshold = queueSize >= 512 ? 512 : queueSize;
        this.putIndex = new AtomicLong(0L);
        this.discardCount = new AtomicLong(0L);
        this.takeIndex = new AtomicLong(0L);
        this.running = new AtomicBoolean(false);
        this.lock = new ReentrantLock(false);
        this.notEmpty = this.lock.newCondition();
    }

    void start(Appender appender, BaseContextEncoder encoder, String workerName) {
        if (appender instanceof AsyncAppender) {
            throw new IllegalArgumentException("nested AsyncAppender is not allow: " + workerName);
        }
        this.appender = ArmsLoggerUtils.checkNotNull(appender, "appender");
        this.encoder = encoder;
        this.workerName = workerName;
        this.worker = new Thread((Runnable)new AsyncRunnable(), "ArmsLogger-AsyncAppender-Thread-" + workerName);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    int size() {
        return (int)(this.putIndex.get() - this.takeIndex.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean append(BaseContext ctx) {
        long size;
        long qsize = this.queueSize;
        long startTime = 0L;
        while (true) {
            long put;
            if ((size = (put = this.putIndex.get()) - this.takeIndex.get()) >= qsize) {
                boolean wait;
                int maxWaitMillis = ctx.isEvent() ? Math.max(this.maxWaitMillis, 1000) : this.maxWaitMillis;
                if (maxWaitMillis <= 0) {
                    wait = false;
                } else {
                    long now = System.currentTimeMillis();
                    if (startTime == 0L) {
                        startTime = now;
                        wait = true;
                    } else {
                        wait = now - startTime < (long)maxWaitMillis;
                    }
                }
                if (!wait) {
                    this.discardCount.incrementAndGet();
                    return false;
                }
                LockSupport.parkNanos(1000L);
                continue;
            }
            if (this.putIndex.compareAndSet(put, put + 1L)) break;
        }
        this.entries[(int)put & this.indexMask] = ctx;
        if (size >= (long)this.notifyThreshold && !this.running.get() && this.lock.tryLock()) {
            try {
                this.notEmpty.signal();
            }
            catch (Exception var17) {
                ArmsLoggerDispatch.selfLog("[ERROR] fail to signal notEmpty: " + this.workerName, var17);
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    @Override
    public void append(String log) {
        throw new UnsupportedOperationException("use append(BaseContext ctx) instead in AsyncAppender");
    }

    @Override
    public void rollOver() {
        this.publishEvent(-2);
    }

    @Override
    public void reload() {
        this.publishEvent(-3);
    }

    @Override
    public void flush() {
        this.publishEvent(-1);
    }

    void flushAndWait() {
        this.publishEventAndWait(-1, 1000L);
    }

    @Override
    public void close() {
        this.publishEvent(-1);
        this.publishEventAndWait(-4, 2000L);
        if (this.worker.getState() != Thread.State.TERMINATED) {
            try {
                this.worker.interrupt();
                this.worker.join(2000L);
            }
            catch (InterruptedException var2) {
                // empty catch block
            }
        }
        Appender appender0 = this.appender;
        this.appender = new NoOpAppender();
        appender0.close();
        ArmsLoggerDispatch.selfLog("[INFO] closed AsyncAppender: " + this);
    }

    @Override
    public void cleanup() {
        this.appender.cleanup();
    }

    private void publishEvent(int eventType) {
        BaseContext event = new BaseContext(eventType);
        this.append(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishEventAndWait(int eventType, long timeoutMillis) {
        BaseContext event = new BaseContext(eventType);
        event.setRpcType(Integer.MIN_VALUE);
        BaseContext baseContext = event;
        synchronized (baseContext) {
            if (this.append(event)) {
                if (!this.running.get() && this.lock.tryLock()) {
                    try {
                        this.notEmpty.signal();
                    }
                    catch (Exception var14) {
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                try {
                    event.wait(timeoutMillis);
                }
                catch (Exception var13) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getOutputLocation() {
        return this.appender.getOutputLocation();
    }

    Appender getAppender() {
        return this.appender;
    }

    void setAppender(Appender appender) {
        this.appender = ArmsLoggerUtils.checkNotNull(appender, "appender");
    }

    public String toString() {
        return "AsyncAppender [appender=" + this.appender + "]";
    }

    class AsyncRunnable
    implements Runnable {
        private final FastException closeEvent = new FastException("Shutdown AsyncRunnable");

        AsyncRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            AsyncAppender parent = AsyncAppender.this;
            int indexMask = parent.indexMask;
            int queueSize = parent.queueSize;
            BaseContextEncoder encoder = parent.encoder;
            String workerName = parent.workerName;
            BaseContext[] entries = parent.entries;
            AtomicLong putIndex = parent.putIndex;
            AtomicLong takeIndex = parent.takeIndex;
            AtomicLong discardCount = parent.discardCount;
            AtomicBoolean running = parent.running;
            ReentrantLock lock = parent.lock;
            Condition notEmpty = parent.notEmpty;
            long outputSpan = TimeUnit.MINUTES.toMillis(1L);
            long lastOutputTime = System.currentTimeMillis();
            BaseContext ctx = null;
            while (true) {
                try {
                    while (true) {
                        long now;
                        running.set(true);
                        long take = takeIndex.get();
                        long size = putIndex.get() - take;
                        if (size <= 0L) {
                            if (!lock.tryLock()) continue;
                            try {
                                running.set(false);
                                notEmpty.await(1L, TimeUnit.SECONDS);
                            }
                            finally {
                                lock.unlock();
                            }
                            continue;
                        }
                        do {
                            int idx = (int)take & indexMask;
                            ctx = entries[idx];
                            while (ctx == null) {
                                Thread.yield();
                                ctx = entries[idx];
                            }
                            entries[idx] = null;
                            takeIndex.set(++take);
                            this.processContext(ctx, parent.appender, encoder);
                        } while (--size > 0L);
                        long discardNum = discardCount.get();
                        if (discardNum > 0L && (now = System.currentTimeMillis()) - lastOutputTime > outputSpan) {
                            discardNum = discardCount.get();
                            discardCount.lazySet(0L);
                            ArmsLoggerDispatch.selfLog("[WARN] " + workerName + " discarded " + discardNum + " logs, queueSize=" + queueSize);
                            lastOutputTime = now;
                        }
                        parent.appender.flush();
                    }
                }
                catch (InterruptedException var31) {
                    ArmsLoggerDispatch.selfLog("[INFO] " + workerName + " async thread is iterrupted");
                }
                catch (Throwable var32) {
                    if (var32 == this.closeEvent) break;
                    ArmsLoggerDispatch.selfLog("[ERROR] fail to async write log " + workerName, var32);
                    continue;
                }
                break;
            }
            running.set(false);
            ArmsLoggerDispatch.selfLog("[INFO] " + workerName + " async thread is exited");
            if (ctx != null && ctx.getRpcType() == -4) {
                this.doNotifyIfRequired(ctx);
            }
        }

        private final void processContext(BaseContext ctx, Appender appender, BaseContextEncoder encoder) throws IOException {
            if (ctx.isEvent()) {
                int logType = ctx.logType;
                if (logType == -1) {
                    appender.flush();
                } else if (logType == -2) {
                    appender.rollOver();
                } else if (logType == -3) {
                    appender.reload();
                } else if (logType == -4) {
                    this.doNotifyIfRequired(ctx);
                    throw this.closeEvent;
                }
                this.doNotifyIfRequired(ctx);
            } else {
                encoder.encode(ctx, appender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void doNotifyIfRequired(BaseContext ctx) {
            if (ctx.getRpcType() == Integer.MIN_VALUE) {
                BaseContext baseContext = ctx;
                synchronized (baseContext) {
                    try {
                        ctx.notifyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

